% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled_spss_survey.R
\name{labelled_spss_survey}
\alias{labelled_spss_survey}
\alias{as_character}
\alias{is.labelled_spss_survey}
\alias{as_numeric}
\title{Labelled vectors for multiple SPSS surveys}
\usage{
labelled_spss_survey(
  x = double(),
  labels = NULL,
  na_values = NULL,
  na_range = NULL,
  label = NULL,
  id = NULL,
  name_orig = NULL
)

as_character(x)

is.labelled_spss_survey(x)

as_numeric(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector or \code{NULL}. The vector should be the same type
as \code{x}. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}

\item{na_values}{A vector of values that should also be considered as missing.}

\item{na_range}{A numeric vector of length two giving the (inclusive) extents
of the range. Use \code{-Inf} and \code{Inf} if you want the range to be
open ended.}

\item{label}{A short, human-readable description of the vector.}

\item{id}{Survey ID}

\item{name_orig}{The original name of the variable. If left \code{NULL}
it uses the latest name of the object \code{x}.}
}
\description{
This class is amending \code{haven::\link[haven]{labelled_spss}} with a unique object
identifier \code{id} to make later binding or joining 
reproducible and well-documented.
}
\details{
It inherits many methods from labelled, but uses more strict
coercion and validation rules.
}
\examples{
x1 <- labelled_spss_survey(
  1:10, c(Good = 1, Bad = 8), 
  na_values = c(9, 10), 
  id = "survey1")
  
is.na(x1)

# Print data and metadata 
print(x1)

x2 <- labelled_spss_survey( 1:10, 
 labels  = c(Good = 1, Bad = 8), 
 na_range = c(9, Inf),
 label = "Quality rating", 
 id = "survey1")


is.na(x2)

# Print data and metadata
x2
}
\seealso{
as_factor

Other type conversion functions: 
\code{\link{as_labelled_spss_survey}()}

Other type conversion functions: 
\code{\link{as_labelled_spss_survey}()}
}
\concept{type conversion functions}
