% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_surveys.R
\name{read_surveys}
\alias{read_surveys}
\title{Read Survey Files}
\usage{
read_surveys(import_file_names, .f = "read_rds", save_to_rds = FALSE)
}
\arguments{
\item{import_file_names}{A vector of file names to import.}

\item{.f}{A function to import the surveys with.
Defaults to \code{'read_rds'}. For SPSS files,
\code{read_spss} is recommended, which is a
well-parameterized version of \code{\link[haven]{read_spss}} that
saves some metadata, too.}

\item{save_to_rds}{Should it save the imported survey to .rds?
Defaults to \code{FALSE}.}
}
\value{
A list of the surveys.  Each element of the list is a data
frame-like \code{\link{survey}} type object where some metadata, 
such as the original file name, doi identifier if present, and other
information is recorded for a reproducible workflow.
}
\description{
Import surveys into a list. Adds filename as a constant to each
element of the list.
}
\details{
The functions handle exceptions with wrong filenames and not readable 
files. If I file cannot be read, a warning is given, and empty survey is added to the 
the list in the place of this file.
}
\examples{
file1 <- system.file(
    "examples", "ZA7576.rds", package = "retroharmonize")
file2 <- system.file(
    "examples", "ZA5913.rds", package = "retroharmonize")

read_surveys (c(file1,file2), .f = 'read_rds' )
}
\seealso{
survey

Other import functions: 
\code{\link{pull_survey}()},
\code{\link{read_dta}()},
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{subset_save_surveys}()}
}
\concept{import functions}
