% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_revision.R
\name{get_revision}
\alias{get_revision}
\title{Extract Tagged Text from a Manuscript}
\usage{
get_revision(
  id,
  manuscript = NULL,
  quote = TRUE,
  evaluate = TRUE,
  split_string = FALSE,
  search_length = 300,
  include_pgnum = TRUE,
  revise_errors = getOption("revise_errors"),
  envir = parent.frame(1L)
)
}
\arguments{
\item{id}{the id as a character string from a html or markdown tag}

\item{manuscript}{Optional; a revise_manuscript object in which to search
for \code{id}. Defaults to \code{NULL}, in which case the manuscript object
is found in the environment.}

\item{quote}{should the output string be quoted by inserting '>' before the string?}

\item{evaluate}{logical. Should inline rchunks be executed?}

\item{split_string}{should only the start and end of the string be searched for?}

\item{search_length}{numeric. Searches for the first n and n characters in a string. Shorten if difficult to find passages split by floats.}

\item{include_pgnum}{logical. include PDF page number? Requires a PDF to be provided to the manuscript object.}

\item{revise_errors}{logical. If FALSE, failure to match manuscript sections will result in warnings rather than errors.}

\item{envir}{The environment in which to find the manuscript.}
}
\value{
A character vector of length 1 containing the text extracted from the manuscript that was tagged with \code{id}, including any modifications as specified by the arguments.
}
\description{
Retrieves and formats a specified section from a revise_manuscript object based on its ID.
}
