% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exercises.R
\name{define_exercises}
\alias{define_exercises}
\alias{define_exercises.exam}
\title{Define exercises from a data frame}
\usage{
define_exercises(ex, df)

\method{define_exercises}{exam}(ex, df)
}
\arguments{
\item{ex}{An `exam` object.}

\item{df}{A data frame containing exercises.}
}
\value{
An `exam`.
}
\description{
Each row in the text data frame is interpreted as an exercise. We only need to define
the columns that we are going to use; the rest of the columns are taken by default.
}
\details{
Both the answer and the options are formed by a vector of strings, from which
one is chosen to formulate the exercise and select the answer. To represent a
vector of strings in a cell, the function `vector_to_string()` is used, which
includes a separator ("<|>") between the vector elements to generate a string.
}
\examples{

rmd <- system.file("extdata/template01.Rmd", package = "rexer")
exercises <- system.file("extdata/exercises.csv", package = "rexer")
q <- read_exercise_csv(exercises)
ex <- exam(
  rmd = rmd,
  examinees = NULL,
  instances_num = 10,
  random = TRUE,
  reorder_exercises = TRUE,
  select_n_exercises = NULL
) |>
  define_exercises(q)

}
\seealso{
\code{\link{exam}}, \code{\link{vector_to_string}}

Other exercise definition: 
\code{\link{define_an_exercise}()},
\code{\link{define_exercises_from_csv}()},
\code{\link{define_exercises_from_excel}()}
}
\concept{exercise definition}
