/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata;

import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.Bounds;
import org.chocosolver.solver.constraints.nary.automata.structure.costregular.StoredValuedDirectedMultiGraph;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.chocosolver.util.procedure.UnaryIntProcedure;

public class PropCostRegular
extends Propagator<IntVar> {
    private final int zIdx;
    private final StoredValuedDirectedMultiGraph graph;
    private final ICostAutomaton cautomaton;
    private final TIntStack toRemove;
    private final IStateBool boundChange;
    private int lastWorld = -1;
    private long lastNbOfBacktracks = -1L;
    private long lastNbOfRestarts = -1L;
    private final RemProc rem_proc;
    private final IIntDeltaMonitor[] idms = new IIntDeltaMonitor[((IntVar[])this.vars).length - 1];

    public PropCostRegular(IntVar[] variables, ICostAutomaton cautomaton, StoredValuedDirectedMultiGraph graph) {
        super((Variable[])variables, (Priority)PropagatorPriority.CUBIC, true);
        for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
            this.idms[i] = ((IntVar[])this.vars)[i].monitorDelta(this);
            this.idms[i].startMonitoring();
        }
        this.zIdx = ((IntVar[])this.vars).length - 1;
        this.rem_proc = new RemProc(this);
        IEnvironment environment = this.model.getEnvironment();
        this.toRemove = new TIntArrayStack();
        this.boundChange = environment.makeBool(false);
        this.graph = graph;
        this.cautomaton = cautomaton;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return vIdx != ((IntVar[])this.vars).length - 1 ? IntEventType.all() : IntEventType.boundAndInst();
    }

    protected void initialize() throws ContradictionException {
        Bounds bounds = this.cautomaton.getCounters().get(0).bounds();
        ((IntVar[])this.vars)[this.zIdx].updateBounds(bounds.min.value, bounds.max.value, this);
        this.prefilter();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.idms.length; ++i) {
                this.idms[i].forEachRemVal(this.rem_proc.set(i));
            }
            this.initialize();
        }
        this.filter();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.checkWorld();
        if (varIdx == this.zIdx) {
            this.boundChange.set(true);
        } else {
            this.idms[varIdx].forEachRemVal(this.rem_proc.set(varIdx));
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int first = this.graph.sourceIndex;
            double cost = 0.0;
            int[] str = new int[((IntVar[])this.vars).length - 1];
            for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
                boolean found = false;
                str[i] = ((IntVar[])this.vars)[i].getValue();
                StoredIndexedBipartiteSetWithOffset bs = this.graph.GNodes.outArcs[first];
                DisposableIntIterator it = bs.getIterator();
                while (!found && it.hasNext()) {
                    int idx = it.next();
                    if (this.graph.GArcs.values[idx] != ((IntVar[])this.vars)[i].getValue()) continue;
                    found = true;
                    first = this.graph.GArcs.dests[idx];
                    cost += this.graph.GArcs.costs[idx];
                }
                if (found) continue;
                return ESat.FALSE;
            }
            int intCost = ((IntVar[])this.vars)[this.zIdx].getValue();
            return ESat.eval(cost == (double)intCost && this.cautomaton.run(str));
        }
        return ESat.UNDEFINED;
    }

    private void prefilter() throws ContradictionException {
        int id;
        double zinf = this.graph.GNodes.spft.get(this.graph.sourceIndex);
        double zsup = this.graph.GNodes.lpfs.get(this.graph.tinkIndex);
        ((IntVar[])this.vars)[this.zIdx].updateBounds((int)Math.ceil(zinf), (int)Math.floor(zsup), this);
        DisposableIntIterator it = this.graph.inGraph.getIterator();
        while (it.hasNext()) {
            id = it.next();
            int orig = this.graph.GArcs.origs[id];
            int dest = this.graph.GArcs.dests[id];
            double acost = this.graph.GArcs.costs[id];
            double spfs = this.graph.GNodes.spfs.get(orig);
            double lpfs = this.graph.GNodes.lpfs.get(orig);
            double spft = this.graph.GNodes.spft.get(dest);
            double lpft = this.graph.GNodes.lpft.get(dest);
            if (!(spfs + spft + acost > (double)((IntVar[])this.vars)[this.zIdx].getUB()) && !(lpfs + lpft + acost < (double)((IntVar[])this.vars)[this.zIdx].getLB()) || !this.graph.isNotInStack(id)) continue;
            this.graph.setInStack(id);
            this.toRemove.push(id);
        }
        it.dispose();
        try {
            while (true) {
                if (this.toRemove.size() > 0) {
                    id = this.toRemove.pop();
                    this.graph.removeArc(id, this.toRemove, this, this);
                    continue;
                }
                while (this.graph.toUpdateLeft.size() > 0) {
                    this.graph.updateLeft(this.graph.toUpdateLeft.pop(), this.toRemove, this);
                }
                while (this.graph.toUpdateRight.size() > 0) {
                    this.graph.updateRight(this.graph.toUpdateRight.pop(), this.toRemove, this);
                }
                if (this.toRemove.size() <= 0) break;
            }
        }
        catch (ContradictionException e) {
            this.toRemove.clear();
            this.graph.inStack.clear();
            this.graph.toUpdateLeft.clear();
            this.graph.toUpdateRight.clear();
            throw e;
        }
    }

    private void checkWorld() {
        int currentworld = this.model.getEnvironment().getWorldIndex();
        long currentbt = this.model.getSolver().getBackTrackCount();
        long currentrestart = this.model.getSolver().getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            this.toRemove.clear();
            this.graph.inStack.clear();
            this.graph.toUpdateLeft.clear();
            this.graph.toUpdateRight.clear();
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    private void filter() throws ContradictionException {
        if (this.boundChange.get()) {
            this.boundChange.set(false);
            DisposableIntIterator it = this.graph.inGraph.getIterator();
            while (it.hasNext()) {
                int id = it.next();
                int orig = this.graph.GArcs.origs[id];
                int dest = this.graph.GArcs.dests[id];
                double acost = this.graph.GArcs.costs[id];
                double lpfs = this.graph.GNodes.lpfs.get(orig);
                double lpft = this.graph.GNodes.lpft.get(dest);
                double spfs = this.graph.GNodes.spfs.get(orig);
                double spft = this.graph.GNodes.spft.get(dest);
                if (!(lpfs + lpft + acost < (double)((IntVar[])this.vars)[this.zIdx].getLB()) && !(spfs + spft + acost > (double)((IntVar[])this.vars)[this.zIdx].getUB()) || !this.graph.isNotInStack(id)) continue;
                this.graph.setInStack(id);
                this.toRemove.push(id);
            }
            it.dispose();
        }
        while (true) {
            if (this.toRemove.size() > 0) {
                int id = this.toRemove.pop();
                this.graph.removeArc(id, this.toRemove, this, this);
                continue;
            }
            while (this.graph.toUpdateLeft.size() > 0) {
                this.graph.updateLeft(this.graph.toUpdateLeft.pop(), this.toRemove, this);
            }
            while (this.graph.toUpdateRight.size() > 0) {
                this.graph.updateRight(this.graph.toUpdateRight.pop(), this.toRemove, this);
            }
            if (this.toRemove.size() <= 0) break;
        }
        double zinf = this.graph.GNodes.spft.get(this.graph.sourceIndex);
        double zsup = this.graph.GNodes.lpfs.get(this.graph.tinkIndex);
        ((IntVar[])this.vars)[this.zIdx].updateBounds((int)Math.ceil(zinf), (int)Math.floor(zsup), this);
    }

    private static class RemProc
    implements UnaryIntProcedure<Integer> {
        private final PropCostRegular p;
        private int idxVar;

        public RemProc(PropCostRegular p) {
            this.p = p;
        }

        @Override
        public UnaryIntProcedure<Integer> set(Integer idxVar) {
            this.idxVar = idxVar;
            return this;
        }

        @Override
        public void execute(int i) throws ContradictionException {
            StoredIndexedBipartiteSetWithOffset sup = this.p.graph.getSupport(this.idxVar, i);
            if (sup != null) {
                DisposableIntIterator it = sup.getIterator();
                while (it.hasNext()) {
                    int arcId = it.next();
                    if (!this.p.graph.isNotInStack(arcId)) continue;
                    this.p.graph.setInStack(arcId);
                    this.p.toRemove.push(arcId);
                }
                it.dispose();
            }
        }
    }
}

