% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/level-set.R
\name{LevelSet}
\alias{LevelSet}
\title{Abstract Class for Level Set Manifolds}
\description{
Class for manifolds embedded in a vector space by a submersion.
}
\author{
Nicolas Guigui and Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{LevelSet}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{embedding_space}}{An object of class \code{\link{VectorSpace}} specifying the
embedding space.}

\item{\code{embedding_metric}}{???}

\item{\code{submersion}}{???}

\item{\code{value}}{???}

\item{\code{tangent_submersion}}{???}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LevelSet-new}{\code{LevelSet$new()}}
\item \href{#method-LevelSet-intrinsic_to_extrinsic_coords}{\code{LevelSet$intrinsic_to_extrinsic_coords()}}
\item \href{#method-LevelSet-extrinsic_to_intrinsic_coords}{\code{LevelSet$extrinsic_to_intrinsic_coords()}}
\item \href{#method-LevelSet-projection}{\code{LevelSet$projection()}}
\item \href{#method-LevelSet-clone}{\code{LevelSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LevelSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-LevelSet-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{LevelSet}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LevelSet$new(
  dim,
  embedding_space,
  submersion,
  value,
  tangent_submersion,
  default_coords_type = "intrinsic",
  ...,
  py_cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{embedding_space}}{An object of class \code{\link{VectorSpace}} specifying the
embedding space.}

\item{\code{submersion}}{???}

\item{\code{value}}{???}

\item{\code{tangent_submersion}}{???}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrinsic} or \code{intrinsic}. Defaults to \code{intrinsic}.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{Manifold}} class.}

\item{\code{py_cls}}{A Python object of class \code{LevelSet}. Defaults to \code{NULL} in
which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{LevelSet}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LevelSet-intrinsic_to_extrinsic_coords"></a>}}
\if{latex}{\out{\hypertarget{method-LevelSet-intrinsic_to_extrinsic_coords}{}}}
\subsection{Method \code{intrinsic_to_extrinsic_coords()}}{
Converts from intrinsic to extrinsic coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LevelSet$intrinsic_to_extrinsic_coords(point_intrinsic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_intrinsic}}{A numeric array of shape \code{dim} specifying a point
in the embedded manifold in intrinsic coordinates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{dim_embedding} representing the same
point in the embedded manifold in extrinsic coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LevelSet-extrinsic_to_intrinsic_coords"></a>}}
\if{latex}{\out{\hypertarget{method-LevelSet-extrinsic_to_intrinsic_coords}{}}}
\subsection{Method \code{extrinsic_to_intrinsic_coords()}}{
Converts from extrinsic to intrinsic coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LevelSet$extrinsic_to_intrinsic_coords(point_extrinsic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_extrinsic}}{A numeric array of shape \code{dim_embedding}
specifying a point in the embedded manifold in extrinsic coordinates,
i.E. in the coordinates of the embedding manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{dim} representing the same point in the
embedded manifold in intrinsic coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LevelSet-projection"></a>}}
\if{latex}{\out{\hypertarget{method-LevelSet-projection}{}}}
\subsection{Method \code{projection()}}{
Projects a point in embedding manifold on embedded manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LevelSet$projection(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \code{dim_embedding} specifying a point
in the embedding manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{dim_embedding} storing the projected
point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LevelSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LevelSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LevelSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
