% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lie-group.R
\name{LieGroup}
\alias{LieGroup}
\title{Abstract Class for Lie Groups}
\description{
Class for Lie groups. In this class, \code{point_type} (\code{'vector'} or
\code{'matrix'}) will be used to describe the format of the points on the Lie
group. If \code{point_type} is \code{'vector'}, the format of the inputs is
\code{dimension}, where \code{dimension} is the dimension of the Lie group. If
\code{point_type} is \code{'matrix'}, the format of the inputs is \code{c(n, n)} where \code{n}
is the parameter of \eqn{\mathrm{GL}(n)} e.g. the amount of rows and
columns of the matrix.
}
\examples{

## ------------------------------------------------
## Method `LieGroup$exp`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$exp_from_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp_from_identity(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$exp_not_from_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp_not_from_identity(rep(0, 3), rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$log`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$log_from_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log_from_identity(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$log_not_from_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log_not_from_identity(rep(0, 3), rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$get_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$get_identity()
}

## ------------------------------------------------
## Method `LieGroup$lie_bracket`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$lie_bracket(diag(0, 3), diag(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$tangent_translation_map`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tangent_translation_map(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$compose`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$compose(rep(0, 3), rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$jacobian_translation`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$jacobian_translation(rep(0, 3))
}

## ------------------------------------------------
## Method `LieGroup$inverse`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$inverse(rep(0, 3))
}
}
\author{
Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{LieGroup}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lie_algebra}}{An object of class \code{\link{MatrixLieAlgebra}} or \code{NULL}
representing the tangent space at the identity.}

\item{\code{left_canonical_metric}}{An object of class \code{InvariantMetric}
representing the left invariant metric that corresponds to the
Euclidean inner product at the identity.}

\item{\code{right_canonical_metric}}{An object of class \code{InvariantMetric}
representing the left invariant metric that corresponds to the
Euclidean inner product at the identity.}

\item{\code{metrics}}{A list of objects of class \code{\link{RiemannianMetric}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LieGroup-new}{\code{LieGroup$new()}}
\item \href{#method-LieGroup-exp}{\code{LieGroup$exp()}}
\item \href{#method-LieGroup-exp_from_identity}{\code{LieGroup$exp_from_identity()}}
\item \href{#method-LieGroup-exp_not_from_identity}{\code{LieGroup$exp_not_from_identity()}}
\item \href{#method-LieGroup-log}{\code{LieGroup$log()}}
\item \href{#method-LieGroup-log_from_identity}{\code{LieGroup$log_from_identity()}}
\item \href{#method-LieGroup-log_not_from_identity}{\code{LieGroup$log_not_from_identity()}}
\item \href{#method-LieGroup-get_identity}{\code{LieGroup$get_identity()}}
\item \href{#method-LieGroup-lie_bracket}{\code{LieGroup$lie_bracket()}}
\item \href{#method-LieGroup-tangent_translation_map}{\code{LieGroup$tangent_translation_map()}}
\item \href{#method-LieGroup-compose}{\code{LieGroup$compose()}}
\item \href{#method-LieGroup-jacobian_translation}{\code{LieGroup$jacobian_translation()}}
\item \href{#method-LieGroup-inverse}{\code{LieGroup$inverse()}}
\item \href{#method-LieGroup-add_metric}{\code{LieGroup$add_metric()}}
\item \href{#method-LieGroup-clone}{\code{LieGroup$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{LieGroup}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$new(dim, shape, lie_algebra = NULL, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
Lie group.}

\item{\code{lie_algebra}}{An object of class \code{\link{MatrixLieAlgebra}} or \code{NULL}
specifying the tangent space at the identity.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{Manifold}} class.}

\item{\code{py_cls}}{A Python object of class \code{LieGroup}. Defaults to \code{NULL} in
which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{LieGroup}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-exp"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-exp}{}}}
\subsection{Method \code{exp()}}{
Exponentiates a left-invariant vector field from a base
point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$exp(tangent_vec, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more tangent vectors at
corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more base points on the
manifold. Defaults to identity if \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The vector input is not an element of the Lie algebra, but of
the tangent space at \code{base_point}: if \eqn{g} denotes \code{base_point},
\eqn{v} the tangent vector, and \eqn{V = g^{-1} v} the associated Lie
algebra vector, then \deqn{\exp(v, g) = \mathrm{mul}(g, \exp(V))}.
Therefore, the Lie exponential is obtained when \code{base_point} is \code{NULL},
or the identity.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group exponential of the input tangent
vector(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-exp_from_identity"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-exp_from_identity}{}}}
\subsection{Method \code{exp_from_identity()}}{
Compute the group exponential of tangent vector from the
identity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$exp_from_identity(tangent_vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more tangent vectors at
corresponding base points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group exponential of the input tangent
vector(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp_from_identity(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-exp_not_from_identity"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-exp_not_from_identity}{}}}
\subsection{Method \code{exp_not_from_identity()}}{
Calculate the group exponential at \code{base_point}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$exp_not_from_identity(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more tangent vectors at
corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more base points on the
manifold. Defaults to identity if \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group exponential of the input tangent
vector(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$exp_not_from_identity(rep(0, 3), rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-log"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-log}{}}}
\subsection{Method \code{log()}}{
Computes a left-invariant vector field bringing \code{base_point}
to \code{point}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$log(point, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more points on the
manifold.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more base points on the
manifold. Defaults to identity if \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The output is a vector of the tangent space at \code{base_point}, so
not a Lie algebra element if \code{base_point} is not the identity.
Furthermore, denoting \code{point} by \eqn{g} and \code{base_point} by \eqn{h},
the output satisfies \deqn{g = \exp(\log(g, h), h)}.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group logarithm of the input point(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-log_from_identity"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-log_from_identity}{}}}
\subsection{Method \code{log_from_identity()}}{
Computes the group logarithm of \code{point} from the identity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$log_from_identity(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more points on the
manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group logarithm of the input point(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log_from_identity(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-log_not_from_identity"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-log_not_from_identity}{}}}
\subsection{Method \code{log_not_from_identity()}}{
Computes the group logarithm at \code{base_point}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$log_not_from_identity(point, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more points on the
manifold.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more base points on the
manifold. Defaults to identity if \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the group logarithm of the input point(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$log_not_from_identity(rep(0, 3), rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-get_identity"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-get_identity}{}}}
\subsection{Method \code{get_identity()}}{
Gets the identity of the group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$get_identity()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric array of shape \eqn{\{ \mathrm{dim}, [n \times n] \}}
storing the identity of the Lie group.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$get_identity()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-lie_bracket"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-lie_bracket}{}}}
\subsection{Method \code{lie_bracket()}}{
Computes the lie bracket of two tangent vectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$lie_bracket(tangent_vector_a, tangent_vector_b, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vector_a}}{A numeric array of shape \eqn{[\dots \times n
  \times n]} specifying one or more tangent vectors at corresponding base
points.}

\item{\code{tangent_vector_b}}{A numeric array of shape \eqn{[\dots \times n
  \times n]} specifying one or more tangent vectors at corresponding base
points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more base points on the
manifold. Defaults to identity if \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For matrix Lie groups with tangent vectors \eqn{A} and \eqn{B}
at the same base point \eqn{P}, this is given by (translate to
identity, compute commutator, go back): \deqn{[A,B] = A_P^{-1}B -
  B_P^{-1}A}.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} storing
the Lie bracket of the two input tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$lie_bracket(diag(0, 3), diag(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-tangent_translation_map"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-tangent_translation_map}{}}}
\subsection{Method \code{tangent_translation_map()}}{
Computes the push-forward map by the left/right translation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$tangent_translation_map(
  point,
  left_or_right = "left",
  inverse = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more points on the
manifold.}

\item{\code{left_or_right}}{A character string specifying whether to compute the map
for the left or right translation. Choices are \code{"left"} or \verb{"right}.
Defaults to \code{"left"}.}

\item{\code{inverse}}{A boolean specifying whether to inverse the Jacobian
matrix. If set to \code{TRUE}, the push forward by the translation by the
inverse of the point is returned. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Computes the push-forward map of the left/right translation by
the point. It corresponds to the tangent map, or differential of the
group multiplication by the point or its inverse. For groups with a
vector representation, it is only implemented at identity, but it can
be used at other points with \code{inverse = TRUE}. This method wraps the
Jacobian translation which actually computes the matrix representation
of the map.
}

\subsection{Returns}{
A function computing the tangent map of the left/right
translation by \code{point}. It can be applied to tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tangent_translation_map(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-compose"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-compose}{}}}
\subsection{Method \code{compose()}}{
Performs function composition corresponding to the Lie
group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$compose(point_a, point_b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_a}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more left factors in
the product.}

\item{\code{point_b}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more right factors in
the product.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the product of \code{point_a} and \code{point_b} along the
first dimension.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$compose(rep(0, 3), rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-jacobian_translation"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-jacobian_translation}{}}}
\subsection{Method \code{jacobian_translation()}}{
Computes the Jacobian of left/right translation by a point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$jacobian_translation(point, left_or_right = "left")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, [n \times n] \}]} specifying one or more points on the
manifold.}

\item{\code{left_or_right}}{A character string specifying whether to compute the map
for the left or right translation. Choices are \code{"left"} or \verb{"right}.
Defaults to \code{"left"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \mathrm{dim} \times
  \mathrm{dim}]} storing the Jacobian of the left/right translation by
\code{point}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$jacobian_translation(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-inverse"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-inverse}{}}}
\subsection{Method \code{inverse()}}{
Computes the inverse law of the Lie group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$inverse(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim},
[n \times n] \}]} specifying one or more points to be inverted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, [n
  \times n] \}]} storing the inverted points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$inverse(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-add_metric"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-add_metric}{}}}
\subsection{Method \code{add_metric()}}{
Adds a metric to the class \verb{$metrics} attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$add_metric(metric)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{An object of class \code{\link{RiemannianMetric}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LieGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LieGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LieGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
