<!-- badges: start -->
![version](https://img.shields.io/github/package-json/v/davidruvolo51/rheroicons?color=%2326709e)
[![R build status](https://github.com/davidruvolo51/rheroicons/workflows/R-CMD-check/badge.svg)](https://github.com/davidruvolo51/rheroicons/actions)
[![CRAN](https://www.r-pkg.org/badges/version/rheroicons)](https://cran.r-project.org/package=rheroicons)
[![GitHub package dependency version](https://img.shields.io/badge/Heroicons-2.0.12-blue)](https://github.com/tailwindlabs/heroicons/releases/tag/v2.0.12)
[![CRAN Monthly Downloads](https://cranlogs.r-pkg.org/badges/rheroicons)](https://cranlogs.r-pkg.org/badges/rheroicons)
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
  <!-- badges: end -->

# rheroicons

The `rheroicons` packages brings to the [Heroicons](https://github.com/tailwindlabs/heroicons) icon library, developed by [Adam Wathan](https://github.com/adamwathan) and [Steve Schoger](https://github.com/sschoger), as R functions for use in your R-based web projects.

All icons are rendered as inline SVG icons. Therefore, no CSS or JavaScript dependencies are loaded into your Shiny application or other web document at runtime!

## Install

Install the stable version from CRAN.

```r
install.packages("rheroicons")
```

The main branch of this repository and the latest release will always be even with the CRAN release. All development will take place on a new branch, and then merged with main when all tests have passed. New releases may be available prior to CRAN acceptance. If this is the case, you can download the GitHub release using the following command. Please note that release may change if revisions were requested.

```r
remotes::install_github("davidruvolo51/rheroicons@*release")
```

## Getting Started

### Finding Icons

There are over 200 icons in the collection. Each icon has three styles: outline, solid, and mini. The `rheroicons` package includes an icon gallery that can be used to find icons and copy the R code.

```r
rheroicons::launch_gallery()
```

In the gallery, click the name of an icon to copy the R code, and then paste the R code directly into your Shiny application.

Alternatively, you can use the `find_icon` function to search for icons.

```r
# returns all icon names
rheroicons::find_icons()

# find icons with `chevron` in the name
rheroicons::find_icons(query = "chevron")

# find icons with `chevron` OR `arrow` in the name
rheroicons::find_icons(query = "chevron|arrow")

# find icons with `down`, `up`, `left`, OR `right` in the name
rheroicons::find_icons(query = "down|up|left|right")

# find icons that end with `down`.
rheroicons::find_icons(query = "(down)$")
```

You can also use the [Heroicons](https://heroicons.com) site to find icons.

### Rendering Icons

When you have found the icon that you would like to use, you can render them into your app or web document using the `rheroicon` function.

```r
# rheroicons version of the magnifying glass circle icon
rheroicons::rheroicon(name = "magnifying-glass-circle")
```

#### Arguments

The `rheroicon` function takes the following arguments.

| Argument | Description              | Options                               | Default              |
|----------|--------------------------|---------------------------------------|----------------------|
| `name`   | icon name                | (use `find_icon` or `launch_gallery`) | ---                  |
| `type`   | icon style               | `outline`, `solid`, `mini`            | `outline`            |
| `class`  | add your own CSS classes | ---                                   | `NULL`               |

Example use:

```r
library(shiny)
tags$button(
  id = "copy",
  class = "button button-copy",
  tags$span("Add to clipboard"),
  rheroicons::rheroicon(
    name = "clipboard-document",
    type="solid"
  )
)
```

### Customizing the appearance of icons

Use the argument `class` to add custom CSS classes to an icon.

```r
library(shiny)
tags$button(
  id = "copy",
  class = "button button-copy",
  tags$span("Add to clipboard"),
  rheroicons::rheroicon(
    name = "clipboard-document",
    type = "solid",
    class = "button-icon"
  )
)
```

However, you may find it easier to use the predefined classes generated by this package. All icons have three types of CSS classes.

- global: `rheroicons`
- set: `rheroicons-outline`, `rheroicons-solid`, or `rheroicons-mini`
- icon: `rhericons-*`, where `*` is the name of the icon. (This is same as the icon name.)

The following table displays the CSS classes by set for the `backspace` icon.

```r
rheroicons::rheroicon(name = "backspace")
```

| Icon Set | Function                                       | CSS classes                                          |
|----------|------------------------------------------------|------------------------------------------------------|
| outline  | `rheroicon(name ="backspace")`                 | `rheroicons rheroicons-outline rheroicons-backspace` |
| solid    | `rheroicon(name ="backspace", type = "solid")` | `rheroicons rheroicons-solid rheroicons-backspace`   |
| mini     | `rheroicon(name ="backspace", type = "mini")`  | `rheroicons rheroicons-mini rheroicons-backspace`    |

You can select and style icons via CSS using these classes. Create a new `tags$style` element and define your styles (or use an external CSS file).

```r
library(shiny)

# ui
ui <- tagList(
  tags$head(
    tags$style(

      # select all instances of rheroicons
      ".rheroicons {
        width: 50px;
        height: 50px;
      }",

      # select all outline icons (set color via the stroke property)
      ".rheroicons-outline {
        stroke: green;
      }",

      # select solid icons (set color via the fill property)
      ".rheroicons-solid {
        fill: red;
      }",

      # select specific icons
      ".rheroicons-home {
        width: 75px;
        height: 75px;
      }",

      # select specific icon of a particular style
      ".rheroicons-outline.rheroicons-home {
        stroke: yellow;
      }"
    )
  )
  # define UI here
  ...
)
```

### Example

The following code demonstrates how to generate icons in Shiny, render solid and outlined icons, and style icons using CSS.

```r
library(shiny)

ui <- tagList(
  tags$head(
    tags$style(
      "body {
        font-size: 16pt;
        background-color: #f6f6f6;
        font-family: Helvetica, Arial, sans-serif;
        margin: 0;
        padding: 0;
      }",
      "main {
        margin: 0 auto;
        box-sizing: content-box;
        padding: 2em;
        max-width: 972px;
      }",
      ".rheroicons {
        width: 75px;
        height: 75px;
      }",
      ".rheroicons-solid {
        fill: #2C497F; 
      }",
      ".circle-icons {
        stroke: #417B5A;
      }",
      ".rheroicons-home-modern.rheroicons-outline {
        width: 44px;
        height: 44px;
      }"
    )
  ),
  tags$main(
    tags$h2("My Shiny App"),
    tags$p("This is my cool Shiny application. Check out some of the icons"),
    tags$div(
      rheroicons::rheroicon(name = "arrow-down-circle", class="circle-icons"),
      rheroicons::rheroicon(name = "arrow-up-circle", class="circle-icons"),
      rheroicons::rheroicon(name = "arrow-left-circle", class="circle-icons"),
      rheroicons::rheroicon(name = "arrow-right-circle", class="circle-icons")
    ),
    tags$div(
      rheroicons::rheroicon(name = "musical-note", type = "solid"),
      rheroicons::rheroicon(name = "musical-note")
    ),
    tags$div(
      rheroicons::rheroicon(name = "home-modern", type = "solid"),
      rheroicons::rheroicon(name = "home-modern")
    )
  )
)

server <- function(input, output) { }
shinyApp(ui, server)
```
