% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependencies}
\alias{dependencies}
\alias{pkg_install}
\alias{pkg_remove}
\title{Manage dependencies}
\usage{
pkg_install(packages)

pkg_remove(packages)
}
\arguments{
\item{packages}{Character vector of package names.}
}
\value{
None. This functions are called for side effects.
}
\description{
Install, remove or update the R package dependencies of your Rhino project.
}
\details{
Use \code{pkg_install()} to install or update a package to the latest version.
Use \code{pkg_remove()} to remove a package.

These functions will install or remove packages from the local \code{{renv}} library,
and update the \code{dependencies.R} and \code{renv.lock} files accordingly, all in one step.
The underlying \code{{renv}} functions can still be called directly for advanced use cases.
See the \href{https://appsilon.github.io/rhino/articles/explanation/renv-configuration.html}{Explanation: Renv configuration}
to learn about the details of the setup used by Rhino.
}
\examples{
\dontrun{
  # Install dplyr
  rhino::pkg_install("dplyr")

  # Update shiny to the latest version
  rhino::pkg_install("shiny")

  # Install a specific version of shiny
  rhino::pkg_install("shiny@1.6.0")

  # Install shiny.i18n package from GitHub
  rhino::pkg_install("Appsilon/shiny.i18n")

  # Install Biobase package from Bioconductor
  rhino::pkg_install("bioc::Biobase")

  # Install shiny from local source
  rhino::pkg_install("~/path/to/shiny")

  # Remove dplyr
  rhino::pkg_remove("dplyr")
}
}
