% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react.R
\name{react_component}
\alias{react_component}
\title{React components}
\usage{
react_component(name)
}
\arguments{
\item{name}{The name of the component.}
}
\value{
A function representing the component.
}
\description{
Declare the React components defined in your app.
}
\details{
There are three steps to add a React component to your Rhino application:
\enumerate{
\item Define the component using JSX and register it with \code{Rhino.registerReactComponents()}.
\item Declare the component in R with \code{rhino::react_component()}.
\item Use the component in your application.
}

Please refer to the \href{https://appsilon.github.io/rhino/articles/tutorial/use-react-in-rhino.html}{Tutorial: Use React in Rhino}
to learn about the details.
}
\examples{
# Declare the component.
TextBox <- react_component("TextBox")

# Use the component.
ui <- TextBox("Hello!", font_size = 20)
}
