% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{g_eucl_cart}
\alias{g_eucl_cart}
\alias{g_eucl_sph}
\title{Euclidean metric tensor}
\usage{
g_eucl_cart(n, coords = paste0("x", 1:n))

g_eucl_sph(n, coords = c("r", paste0("ph", 1:(n - 1))))
}
\arguments{
\item{n}{The dimension of the metric tensor.}

\item{coords}{A character vector of coordinate names. The length needs
to match the tensor dimensions.}
}
\value{
The covariant metric tensor as array imputed with coordinate names.
}
\description{
Provides the Euclidean metric tensor of \eqn{\mathbb{E}^n}{E^n}.
\code{g_eucl_cart()} returns a numeric (constant) tensor in Cartesian coordinates,
\deqn{ds^2=\sum_{i=1}^n dx_i^2}
while \code{g_eucl_sph()} returns a symbolic tensor field in generalized spherical
coordinates \eqn{{r, \phi_1, \phi_2, ..., \phi_{n-1}}}{{r, `ph1`, `ph2`, ..., `ph(n-2)`}}.
\deqn{ds^2=dr^2 + r^2 d\Omega^2}
}
\details{
As usual, spherical coordinates are degenerate at \eqn{r = 0} and \eqn{\phi_l = 0}, so be
careful around those points.
}
\examples{
g_eucl_cart(3)
g_eucl_cart(3) \%_\% .(+i, +j)
g_eucl_sph(3)
g_eucl_sph(3) \%_\% .(+i, +j)
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Metric_tensor#Euclidean_metric}{Euclidean metric tensor}

Other metric tensors: 
\code{\link{g_mink_cart}()},
\code{\link{g_sph}()},
\code{\link{g_ss}()},
\code{\link{metric_field}()}
}
\concept{metric tensors}
\concept{metric_tensors}
