% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rice.R
\name{adjust.background}
\alias{adjust.background}
\title{Adjust a radiocarbon age for background measurements}
\usage{
adjust.background(y, er, bg, bg.er, timescale = "C14")
}
\arguments{
\item{y}{The age of the sample (in C14 by default, but can also be in F or pMC).}

\item{er}{The error of the date.}

\item{bg}{The background measurement. Should be in the same timescale as that of the sample.}

\item{bg.er}{The error of the background measurement. Should be in the same timescale as that of the sample.}

\item{timescale}{Type of radiocarbon age. Can be in `C14` (default), `F14C` or `pMC`.}
}
\value{
The background-adjusted age.
}
\description{
Calculate the radiocarbon age by adjusting it for a measured background. It is planned to update this function to more properly reflect calculations in the 14CHRONO lab.
}
\details{
Radiocarbon ages are measured using a series of standards and backgrounds, and the raw values are then corrected for these background values. Backgrounds are >0 (in F14C) owing to contamination in even the cleanest lab.
}
\examples{
  adjust.background(9000, 50, 45000, 200)
}
\author{
Maarten Blaauw
}
