% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{pMCtoDelta14C}
\alias{pMCtoDelta14C}
\title{Transform pMC into Delta14C}
\usage{
pMCtoDelta14C(pMC, er = NULL, t, roundby = NA)
}
\arguments{
\item{pMC}{The pMC value to translate}

\item{er}{Reported error of the pMC value. Returns just the mean if left empty.}

\item{t}{the cal BP age}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}
}
\value{
The corresponding Delta14C value
}
\description{
Transform pMC into Delta14C
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates F14C values into Delta14C, the historical level of Delta14C in the year t cal BP. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
  pMCtoDelta14C(0.985, .1, 222)
}
