% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bures-wasserstein.R
\name{bures_wasserstein_exp}
\alias{bures_wasserstein_exp}
\title{Compute the Bures-Wasserstein Exponential}
\usage{
bures_wasserstein_exp(sigma, v, validate = FALSE)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{v}{A symmetric matrix of class \code{dspMatrix}, representing the tangent vector to be mapped.}

\item{validate}{A logical value indicating whether to validate input arguments. Default is FALSE.}
}
\value{
A symmetric positive-definite matrix of class \code{dppMatrix}, representing the point on the manifold.
}
\description{
This function computes the Riemannian exponential map using the Bures-Wasserstein metric for symmetric positive-definite matrices. The map operates by solving a Lyapunov equation and then constructing the exponential.
}
