% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_config.R
\name{set_parallel_plan}
\alias{set_parallel_plan}
\title{Set Parallel Processing Plan}
\usage{
set_parallel_plan(strategy = "sequential", workers = NULL)
}
\arguments{
\item{strategy}{Character string specifying the parallel strategy:
\itemize{
\item \code{"sequential"}: No parallelization (default for safety)
\item \code{"multisession"}: Parallel processing using multiple R sessions (works on all platforms including Windows)
\item \code{"multicore"}: Parallel processing using forked R processes (Unix-like systems only, faster but not available on Windows)
\item \code{"cluster"}: Parallel processing on a cluster of machines
}}

\item{workers}{Integer specifying the number of parallel workers.
If \code{NULL} (default), uses \code{parallel::detectCores() - 1} to leave one core free.
Ignored when \code{strategy = "sequential"}.}
}
\value{
Invisibly returns the future plan object.
}
\description{
Configure the parallel processing strategy for riemtan operations.
Uses the future package to manage parallel backends.
}
\details{
The \code{multisession} strategy is recommended for most users as it works on all platforms.
The \code{multicore} strategy is faster on Unix-like systems but is not available on Windows.

To disable parallel processing, use \code{set_parallel_plan("sequential")}.
}
\examples{
\dontrun{
# Enable parallel processing with automatic worker detection
set_parallel_plan("multisession")

# Use 4 parallel workers
set_parallel_plan("multisession", workers = 4)

# Disable parallel processing
set_parallel_plan("sequential")
}

}
\seealso{
\code{\link[future:plan]{future::plan()}}, \code{\link[=is_parallel_enabled]{is_parallel_enabled()}}, \code{\link[=should_parallelize]{should_parallelize()}}
}
