% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{tidy.risks}
\alias{tidy.risks}
\title{Tidy model summaries for risks models}
\usage{
\method{tidy}{risks}(
  x,
  conf.int = TRUE,
  conf.level = 0.95,
  bootrepeats = 1000,
  bootci = c("bca", "normal", "nonpar"),
  bootverbose = FALSE,
  exponentiate = FALSE,
  default = TRUE,
  ...
)
}
\arguments{
\item{x}{Model}

\item{conf.int}{Show confidence intervals?}

\item{conf.level}{Optional. Confidence level. Defaults to \code{0.95}.}

\item{bootrepeats}{Optional. Number of bootstrap repeats.
Applicable to models fitted via marginal standardization and bootstrapping
(\code{approach = "margstd_boot"}). Defaults to 1000. Strongly recommended
to increase repeats to >>1000.}

\item{bootci}{Optional and applicable for \code{approach = "margstd_boot"}
only. Type of bootstrap confidence interval:
\itemize{
\item \code{"bca"} Default. Parametric BCa (bias-corrected accelerated)
confidence intervals.
\item \code{"normal"} Parametric normality-based confidence intervals,
which require lower repeat numbers but are less accurate and
may result in invalid results for ratios.
\item \code{"nonpar"} Non-parametric BCa confidence intervals,
which should be used with caution because of the risk
of sparse-data bias with non-parametric bootstrapping.
}}

\item{bootverbose}{Optional. Add values of \code{bootrepeats} and
\code{bootci} parameters and the jackknife-based Monte-Carlo error for the
confidence limits (only for \code{type = "bca"}) to the returned tibble?
Defaults to \code{FALSE}.}

\item{exponentiate}{Optional. Exponentiate coefficients and confidence
limits? Defaults to FALSE. Setting \code{exponentiate = TRUE} is useful for
relative risk models (log links).}

\item{default}{Use default, normality-based confidence intervals?
Defaults to TRUE. With \code{default = FALSE}, for binomial models only,
profile likelihood-based confidence intervals can be calculated.}

\item{...}{Passed on}
}
\value{
tibble
}
\description{
Obtain a tibble (data frame) with parameters,
coefficients, standard errors, confidence limits,
and p-values. A column with the type of model fitted is added.
}
\details{
If multiple types of models are fitted, \code{tidy()} can be used
to parameters for all models at once, in one tibble. The last
column of the tibble includes the name of the model. See examples.
}
\examples{
# Define example data
library(broom)  # provides tidy() function

# Fit and tidy the model
fit_rr <- riskratio(
  formula = death ~ stage + receptor,
  data = breastcancer)
tidy(fit_rr)

# Marginal standardization,
# increase number of bootstrap repeats:
\donttest{
fit_rr <- riskratio(
  formula = death ~ stage + receptor,
  data = breastcancer,
  approach = "margstd_boot")
tidy(fit_rr, bootrepeats = 2000)
}

# Multiple types of models fitted:
\donttest{
fit_rr <- riskratio(
  formula = death ~ stage + receptor,
  data = breastcancer,
  approach = "all")
tidy(fit_rr)
}
}
