% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{as_pb}
\alias{as_pb}
\title{Display a percentage as a (numeric and rounded) probability.}
\usage{
as_pb(perc, n_digits = 4)
}
\arguments{
\item{perc}{A percentage (as a scalar or vector of numeric values from 0 to 100).}

\item{n_digits}{Number of decimal places to which percentage is rounded.
Default: \code{n_digits = 4}.}
}
\value{
A probability (as a numeric value).
}
\description{
\code{as_pb} is a function that displays a percentage \code{perc}
as a probability (rounded to \code{n_digits} decimals).
}
\details{
\code{as_pb} and its complement function \code{\link{as_pc}} allow
toggling the display of numeric values between percentages and probabilities.
}
\examples{
as_pb(1/3)          # => 0.0033
as_pb(as_pc(2/3))   # => 0.6667 (rounded to 4 decimals)

}
\seealso{
\code{\link{is_perc}} verifies a percentage;
\code{\link{is_prob}} verifies a probability;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements.

Other utility functions: 
\code{\link{as_pc}()},
\code{\link{plot.box}()},
\code{\link{print.box}()}

Other display functions: 
\code{\link{as_pc}()}
}
\concept{display functions}
\concept{utility functions}
