% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_crisk}
\alias{pal_crisk}
\title{Color palette for cumulative risk curve.}
\format{
An object of class \code{character} of length 10.
}
\usage{
pal_crisk
}
\description{
\code{pal_crisk} defines a default color palette
for the \code{\link{plot_crisk}} function
(as a named vector).
}
\details{
Color names and referents in plots
generated by \code{\link{plot_crisk}}:

\enumerate{
\item \code{"cum"}: Cumulative risk curve
\item \code{"rinc"}: Relative risk increments

\item \code{"txt"}: Text labels
\item \code{"aux"}: Auxiliary labels and lines
\item \code{"high"}: Highlighting elements

\item \code{"pas"}: Past/passed risk
\item \code{"rem"}: Remaining risk

\item \code{"delta"}: Delta-X- and -Y increments
\item \code{"poly"}: Polygon of increments
\item \code{"popu"}: Population partitions
}
}
\examples{
pal_crisk  # show color palette (and names)

}
\seealso{
\code{\link{plot_crisk}} plots cumulative risk curves;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other color palettes: 
\code{\link{pal_bw}},
\code{\link{pal_bwp}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}}
}
\concept{color palettes}
\keyword{datasets}
