% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\docType{data}
\name{scenarios}
\alias{scenarios}
\title{A collection of riskyr scenarios from various sources (as list).}
\format{
A list with currently 25 scenarios of class \code{riskyr}
which are each described by 21 variables.
}
\usage{
scenarios
}
\description{
\code{scenarios} is a list of scenarios of class \code{riskyr}
collected from the scientific literature and other sources
and to be used by visualization and summary functions.
}
\details{
\code{scenarios} currently contains the following scenarios
(n1 to n12 in English language, n13 to n25 in German language):

\enumerate{

  \item Bowel cancer screening
  \item Cab problem
  \item Hemoccult test
  \item Mammography screening
  \item Mammography (freq)
  \item Mammography (prob)
  \item Mushrooms
  \item Musical town
  \item PSA test (baseline)
  \item PSA test (patients)
  \item Psylicraptis screening
  \item Sepsis

  \item Amniozentese (in German language)
  \item HIV-Test 1
  \item HIV-Test 2
  \item HIV-Test 3
  \item HIV-Test 4
  \item Mammografie 1
  \item Mammografie 2
  \item Mammografie 3
  \item Mammografie 4
  \item Nackenfaltentest (NFT) 1
  \item Nackenfaltentest (NFT) 2
  \item Sigmoidoskopie 1
  \item Sigmoidoskopie 2
}

Variables describing a scenario:

\enumerate{

  \item \code{scen_lbl}: Text label for current scenario.
  \item \code{scen_lng}: Language of current scenario (en/de).
  \item \code{scen_txt}: Description text of current scenario.

  \item \code{popu_lbl}: Text label for current population.

  \item \code{cond_lbl}: Text label for current condition.
  \item \code{cond_true_lbl}: Text label for \code{\link{cond_true}} cases.
  \item \code{cond_false_lbl}: Text label for \code{\link{cond_false}} cases.

  \item \code{dec_lbl}: Text label for current decision.
  \item \code{dec_pos_lbl}: Text label for \code{\link{dec_pos}} cases.
  \item \code{dec_neg_lbl}: Text label for \code{\link{dec_neg}} cases.

  \item \code{hi_lbl}: Text label for cases of hits \code{\link{hi}}.
  \item \code{mi_lbl}: Text label for cases of misses \code{\link{mi}}.
  \item \code{fa_lbl}: Text label for cases of false alarms \code{\link{fa}}.
  \item \code{cr_lbl}: Text label for cases of correct rejections \code{\link{cr}}.

  \item \code{prev}: Value of current prevalence \code{\link{prev}}.
  \item \code{sens}: Value of current sensitivity \code{\link{sens}}.
  \item \code{spec}: Value of current specificity \code{\link{spec}}.
  \item \code{fart}: Value of current false alarm rate \code{\link{fart}}.

  \item \code{N}: Current population size \code{\link{N}}.

  \item \code{scen_src}: Source information for current scenario.
  \item \code{scen_apa}: Source information in APA format.

}

Note that names of variables (columns)
correspond to a subset of \code{\link{init_txt}} (to initialize \code{\link{txt}})
and \code{\link{init_num}} (to initialize \code{\link{num}}).

The variables \code{scen_src} and \code{scen_apa}
provide a scenario's source information.

The information of \code{scenarios} is also contained in an
R data frame \code{\link{df_scenarios}} (and generated from
the corresponding \code{.rda} file in \code{/data/}).
}
\seealso{
\code{\link{riskyr}} initializes a \code{riskyr} scenario.
}
\keyword{datasets}
