% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{landfireVSI}
\alias{landfireVSI}
\title{Read in LANDFIRE products using the GDAL \verb{virtual file system}}
\usage{
landfireVSI(landfire_api)
}
\arguments{
\item{landfire_api}{A \code{landfire_api} object created by \code{landfireAPIv2()}}
}
\value{
SpatRaster object of the requested LANDFIRE product/s
}
\description{
\code{landfire_vsi()} opens a request LANDFIRE GeoTIFF using the GDAL \verb{virtual file system} (VSI).
}
\details{
The GDAL virtual file system allows you to read in LANDFIRE products without
having to download the file to your local machine within 60 minutes of the
request or if the file already exists on your local machine without having
to unzip it.
}
\examples{
\dontrun{
aoi  <- c("-113.79", "42.148", "-113.56", "42.29")
email <- "email@example"
rast <- landfireAPIv2(products = "240EVC",
                      aoi = aoi, email = email,
                      method = "none")  |>
        landfireVSI()
}
}
