% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{index_to_run}
\alias{index_to_run}
\alias{index_to_run.rle}
\title{Map an element in a vector represented by an \code{\link{rle}} to its run}
\usage{
index_to_run(x, i, ...)

\method{index_to_run}{rle}(x, i, ...)
}
\arguments{
\item{x}{an \code{\link{rle}} object.}

\item{i}{a numeric vector of indices to map; fractional values are
rounded down.}

\item{...}{additional arguments to methods.}
}
\value{
An integer vector. Negative values of \code{i} and 0 are always
mapped to 0. Indexes above the range represented by \code{x} are
mapped to the number of runs + 1.
}
\description{
Map an element in a vector represented by an \code{\link{rle}} to its run
}
\note{
This function is generic for future-proofing.
}
\examples{
# From example(rle):
z <- c(TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, TRUE)
rle(z)

stopifnot(identical(
  index_to_run(rle(z), (-1):10),
  c(0L, 0L, 1L, 1L, 2L, 2L, 3L, 4L, 5L, 5L, 5L, 6L)
))
}
