% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mincut.R
\name{AllPairsMinCut}
\alias{AllPairsMinCut}
\title{Solver for All-Pairs MinCut}
\usage{
AllPairsMinCut(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes,
  algorithm = "GomoryHu"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's arcs}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "GomoryHu". "GomoryHu" is the
default.}
}
\value{
A namedlist containing three entries: 1) "predecessors": a vector of
  predecessor nodes of each node in the graph, and 2) "weights": a vector of
  weights of the predecessor edge of each node, and 3) "distances": vector
  of distances from the root node to each node.
}
\description{
Finds the all-pairs minimum cut tree, using the Gomory-Hu algorithm.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00182.html}.
}
