% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphsearch.R
\name{MaxCardinalitySearch}
\alias{MaxCardinalitySearch}
\title{Solver for Max Cardinality Search}
\usage{
MaxCardinalitySearch(
  arcSources,
  arcTargets,
  arcCapacities,
  numNodes,
  startNode = -1,
  algorithm = "maxcardinalitysearch"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcCapacities}{Vector corresponding to the distances of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}

\item{startNode}{Optional start node of the path}

\item{algorithm}{Choices of algorithm include "maxcardinalitysearch".
maxcardinalitysearch is the default.}
}
\value{
A named list containing two entries: 1) "cardinalities": the
  cardinality of each node , 2) "node_reached": a logical vector indicating
  whether a node was reached or not
}
\description{
Runs the maximum cardinality search algorithm on a directed graph. The
maximum cardinality search first chooses any node of the digraph. Then every
time it chooses one unprocessed node with maximum cardinality, i.e the sum
of capacities on out arcs to the nodes which were previously processed. If
there is a cut in the digraph the algorithm should choose again any
unprocessed node of the digraph.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00255.html}.
}
