% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{reverseMethData}
\alias{reverseMethData}
\title{Create "scaled data" for DNA methylation datasets}
\usage{
reverseMethData(object, useDatasets, verbose = getOption("ligerVerbose", TRUE))
}
\arguments{
\item{object}{A \linkS4class{liger} object, with variable genes identified.}

\item{useDatasets}{Required. A character vector of the names, a numeric or
logical vector of the index of the datasets that should be identified as
methylation data where the reversed data will be created.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}
}
\value{
The input \linkS4class{liger} object, where the \code{scaleData} slot
of the specified datasets will be updated with value as described in
Description.
}
\description{
Because gene body mCH proportions are negatively correlated with gene
expression level in neurons, we need to reverse the direction of the
methylation data. We do this by simply subtracting all values from the
maximum methylation value. The resulting values are positively correlated
with gene expression. This will only be applied to variable genes detected in
prior.
}
\examples{
# Assuming the second dataset in example data "pbmc" is methylation data
pbmc <- normalize(pbmc, useDatasets = 1)
pbmc <- selectGenes(pbmc, datasets.use = 1)
pbmc <- scaleNotCenter(pbmc, useDatasets = 1)
pbmc <- reverseMethData(pbmc, useDatasets = 2)
}
