% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_map_outcrop.R
\name{get_map_outcrop}
\alias{get_map_outcrop}
\title{Retrieve geologic map outcrop shape element data}
\usage{
get_map_outcrop(
  map_id = NULL,
  unit_id = NULL,
  strat_name_id = NULL,
  lat = NULL,
  lng = NULL,
  scale = NULL,
  sf = TRUE
)
}
\arguments{
\item{map_id}{\code{integer}. The unique identification number(s) of the
map outcrop shape element(s) to return.}

\item{unit_id}{\code{integer}. Filter outcrop shape elements to those that
match one or more Macrostrat unit(s) as specified by their unique
identification number(s).}

\item{strat_name_id}{\code{integer}. Filter outcrop shape elements to those
that match one or more stratigraphic name(s) as specified by their unique
identification number(s).}

\item{lat}{\code{numeric}. Return the outcrop shape element(s) at the
specified decimal degree latitude. Must also specify \code{lng}.}

\item{lng}{\code{numeric}. Return the outcrop shape element(s) at the
specified decimal degree longitude. Must also specify \code{lat}.}

\item{scale}{\code{character}. The Macrostrat map scale to use (a vector of
scales is also supported). Options are "tiny" (global), "small"
(continental), "medium" (regional), or "large" (local).}

\item{sf}{\code{logical}. Should the results be returned as an \code{sf} object?
Defaults to \code{TRUE}. If \code{FALSE}, a \code{data.frame} is returned.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{map_id}: The identification number of the outcrop shape
element.
\item \code{source_id}: The identification number of the source geologic
map.
\item \code{name}: The name of the outcrop shape element in the original
(or modified) source geologic map.
\item \code{strat_name}: The geologic name(s) of the outcrop shape
element.
\item \code{lith}: The lithology of the outcrop shape element as defined
in the geologic map source in plain text.
\item \code{descrip}: Description of the outcrop shape element in plain
text.
\item \code{comments}: Notes assigned to the outcrop shape element.
\item \code{macro_units}: A vector containing the unique identification
number(s) for known Macrostrat unit(s) matched to the outcrop shape
element.
\item \code{strat_names}: A vector containing the unique identification
number(s) for known stratigraphic unit name(s) matched to the outcrop
shape element (see \code{\link[=def_strat_names]{def_strat_names()}}).
\item \code{liths}: A vector containing the unique identification
number(s) of the lithology(ies) represented within the outcrop shape
element (see \code{\link[=def_lithologies]{def_lithologies()}}).
\item \code{t_int_id}: The identification number of the
chronostratigraphic interval containing the top boundary of the outcrop
shape element.
\item \code{t_int_age}: The top age of the chronostratigraphic interval
containing the top boundary of the outcrop shape element.
\item \code{t_int_name}: The name of the chronostratigraphic interval
containing the top boundary of the outcrop shape element.
\item \code{b_int_id}: The identification number of the
chronostratigraphic interval containing the bottom boundary of the
outcrop shape element.
\item \code{b_int_age}: The bottom age of the chronostratigraphic
interval containing the bottom boundary of the outcrop shape element.
\item \code{b_int_name}: The name of the chronostratigraphic interval
containing the bottom boundary of the outcrop shape element.
\item \code{color}: Recommended color for plotting the outcrop shape
element based on the dominant lithology.
\item \code{t_age}: The estimated top age (minimum age) of the outcrop
shape element, in millions of years before present.
\item \code{b_age}: The estimated bottom age (maximum age) of the outcrop
shape element, in millions of years before present.
\item \code{best_int_name}: The best/most representative interval name
for the outcrop shape element.
}
If \code{sf} is \code{TRUE} (the default), an \code{sf} object is returned instead, with
the same columns plus a "geometry" column that contains the spatial data.
}
\description{
A function to retrieve data for geologic map outcrop shape
elements from various sources.
}
\details{
More information can be found for the inputs for this function
using the definition functions (beginning with \code{def_}).
}
\section{Developer(s)}{

William Gearty
}

\section{Reviewer(s)}{

Lewis A. Jones
}

\examples{
\donttest{
ex1 <- get_map_outcrop(lat = 43, lng = -89.3)
ex2 <- get_map_outcrop(lat = 43, lng = -89.3, scale = "tiny")
}
}
\seealso{
Geologic maps:
\code{\link{def_sources}()},
\code{\link{get_map_legends}()},
\code{\link{get_map_points}()}
}
\concept{maps}
