% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{rule}
\alias{rule}
\alias{rmake.rule}
\title{General creator of an instance of the S3 \code{rmake.rule} class}
\usage{
rule(
  target,
  depends = NULL,
  build = NULL,
  clean = NULL,
  task = "all",
  phony = FALSE,
  type = ""
)
}
\arguments{
\item{target}{A character vector of target file names that are created by the given build command}

\item{depends}{A character vector of file names the build command depends on}

\item{build}{A shell command that runs the build of the given target}

\item{clean}{A shell command that erases all files produced by the build command}

\item{task}{A character vector of parent task names. The mechanism of tasks allows
grouping rules. Anything different from \code{'all'} will
cause the creation of a new task depending on the given rule. Executing \verb{make taskname}
will then force building this rule.}

\item{phony}{Whether the rule has a \code{PHONY} (i.e., non-file) target. A rule should be marked with
\code{phony} if the target is not a file name that would be generated by the \code{build} commands.
E.g., \code{all} or \code{clean} are phony targets. Also, all targets representing tasks (see \code{task} above) are phony.}

\item{type}{A string representing a type of rule used e.g. when printing a rule in an easily readable format.
For instance, \code{\link[=rRule]{rRule()}} uses \code{R}, \code{\link[=markdownRule]{markdownRule()}} uses \code{markdown}, etc.}
}
\value{
Instance of S3 class \code{rmake.rule}
}
\description{
A rule is an atomic element of the build process. It defines a set of \code{target} file names
to be built with a given \code{build} command from a given set of \code{depends} files
that the targets depend on, and which can be removed by a given \code{clean} command.
}
\details{
If there is a need to group some rules together, one can assign them the same task identifier in
the \code{task} argument. Each rule may be assigned one or more tasks. Tasks may then be built
by executing \verb{make task_name} on the command line, which forces rebuilding of all rules assigned to
task \code{'task_name'}. By default, all rules are assigned to task \code{all},
which causes the \verb{make all} command to build everything.
}
\examples{
r <- rule(target='something.abc',
          depends=c('file.a', 'file.b', 'file.c'),
          build='myCompiler file.a file.b file.c -o something.abc',
          clean='$(RM) something.abc')

# generate the content of a makefile (as character vector)
makefile(list(r))

# generate to file
tmp <- tempdir()
makefile(list(r), file.path(tmp, "Makefile"))
}
\seealso{
\code{\link[=makefile]{makefile()}}, \code{\link[=inShell]{inShell()}}
}
\author{
Michal Burda
}
