/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.graphViewer;

import dmLab.experiment.ExperimentParams;
import dmLab.gui.dataEditor.windows.AboutWindow;
import dmLab.gui.graphViewer.GraphViewerInfo;
import dmLab.gui.graphViewer.components.GraphViewerMenu;
import dmLab.gui.graphViewer.components.GraphViewerToolBar;
import dmLab.gui.graphViewer.visualization.GraphVisualization;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesID.IDLoader;
import dmLab.mcfs.attributesID.graph.IDGraph;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.FileUtils;
import dmLab.utils.fileFilters.ComplexFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public final class GraphViewerBody
extends JFrame
implements ActionListener {
    private GraphViewerMenu menuBar;
    private JFileChooser fileDialog;
    private GraphViewerToolBar toolBar;
    private JScrollPane graphPane;
    private JSplitPane horizontalSplitPanel;
    public AttributesID connections;
    private IDGraph graph;
    public GraphVisualization graphVisualization = new GraphVisualization();
    private AboutWindow aboutWindow;
    public static int TOP_SET_MAX_SLIDER_VALUE = 500;

    public GraphViewerBody() {
        this.connections = new AttributesID(true, false);
        GraphViewerBody graphViewerBody = this;
        graphViewerBody.setTitle("dmLab - ID Graphs Viewer");
        GraphViewerBody graphViewerBody2 = graphViewerBody;
        graphViewerBody.fileDialog = new JFileChooser(ExperimentParams.DEFAULT_RES_PATH);
        graphViewerBody2.fileDialog.setLocation(100, 100);
        Object object = new ComplexFileFilter[]{new ComplexFileFilter(new String[]{"connections.csv"}, "CSV Connections File"), new ComplexFileFilter(new String[]{"xml"}, "JGraph XML File")};
        for (int i = 0; i < ((ComplexFileFilter[])object).length; ++i) {
            graphViewerBody2.fileDialog.addChoosableFileFilter(object[i]);
        }
        graphViewerBody2.fileDialog.addChoosableFileFilter(new ComplexFileFilter(new String[]{"csv", "xml"}, "All Supported Files"));
        graphViewerBody2 = graphViewerBody;
        graphViewerBody.menuBar = new GraphViewerMenu();
        GraphViewerBody graphViewerBody3 = graphViewerBody2;
        object = graphViewerBody2.menuBar;
        object.openFileMenuItem.addActionListener(graphViewerBody3);
        object.saveFileMenuItem.addActionListener(graphViewerBody3);
        object.closeFileMenuItem.addActionListener(graphViewerBody3);
        object.exitMenuItem.addActionListener(graphViewerBody3);
        object.aboutMenuItem.addActionListener(graphViewerBody3);
        GraphViewerBody graphViewerBody4 = graphViewerBody2;
        graphViewerBody4.setJMenuBar(graphViewerBody4.menuBar);
        graphViewerBody2.menuBar.setPreferredSize(new Dimension(392, 18));
        graphViewerBody.setSize(800, 700);
        graphViewerBody.setLocation(200, 100);
        graphViewerBody.toolBar = new GraphViewerToolBar(graphViewerBody);
        GraphViewerToolBar cfr_ignored_0 = graphViewerBody.toolBar;
        graphViewerBody.horizontalSplitPanel = new JSplitPane();
        graphViewerBody.getContentPane().add((Component)graphViewerBody.horizontalSplitPanel, "Center");
        graphViewerBody.horizontalSplitPanel.setOrientation(0);
        graphViewerBody.horizontalSplitPanel.add((Component)graphViewerBody.toolBar, "top");
        graphViewerBody.toolBar.setPreferredSize(new Dimension(790, 100));
        graphViewerBody.drawGraph();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        void var1_1;
        Object eventObject = event.getSource();
        if (eventObject == this.menuBar.openFileMenuItem) {
            eventObject = this;
            int n = ((GraphViewerBody)eventObject).fileDialog.showOpenDialog((Component)eventObject);
            if (n != 1 && n == 0) {
                super.closeFile();
                Object object = ((GraphViewerBody)eventObject).fileDialog.getSelectedFile();
                System.out.println("Loading connections file: " + ((File)object).getAbsolutePath());
                String string = MCFSParams.getExperimentName(((File)object).getAbsolutePath());
                boolean bl = false;
                if (FileUtils.getFileExtension(((File)object).getName()).equalsIgnoreCase("csv")) {
                    String string2 = ((File)object).getAbsolutePath();
                    AttributesID attributesID = ((GraphViewerBody)eventObject).connections;
                    IDLoader iDLoader = new IDLoader();
                    bl = iDLoader.load(string2, attributesID);
                } else if (FileUtils.getFileExtension(((File)object).getName()).equalsIgnoreCase("xml")) {
                    bl = ((GraphViewerBody)eventObject).graphVisualization.loadGraph(((File)object).getAbsolutePath());
                }
                if (bl) {
                    System.out.println("Connections are loaded.");
                    ((Frame)eventObject).setTitle("dmLab - ID Graphs Viewer - " + ((File)object).getName());
                    object = new File(string + "_" + MCFSParams.FILESUFIX_RI);
                    System.out.println("Loading importances file: " + ((File)object).getAbsolutePath());
                    if (!((GraphViewerBody)eventObject).toolBar.loadImportanceFile((File)object)) {
                        System.out.println("Lading importances failed.");
                    }
                    ((GraphViewerBody)eventObject).toolBar.initWeightSlider(((GraphViewerBody)eventObject).connections);
                    ((GraphViewerBody)eventObject).toolBar.initTopSetSlider(((GraphViewerBody)eventObject).connections);
                    object = new Ranking();
                    File file = new File(string + MCFSParams.FILESUFIX_TOPRANKING);
                    System.out.println("Loading topRanking file: " + file.getAbsolutePath());
                    int n2 = ((GraphViewerBody)eventObject).connections.getNodesNumber();
                    float f = ((GraphViewerBody)eventObject).connections.getIDWeight(20);
                    if (((GraphViewerBody)eventObject).toolBar.isImportanceLoaded()) {
                        if (((Ranking)object).load(file.getAbsolutePath())) {
                            n2 = ((Ranking)object).size();
                            Object object2 = object;
                            ((GraphViewerBody)eventObject).graphVisualization.setMinImportanceValue(((Ranking)object2).getWeight(((Ranking)object2).size() - 1));
                        } else {
                            System.out.println("Lading topRanking failed.");
                            n2 = 20;
                        }
                        f = 0.0f;
                    }
                    ((GraphViewerBody)eventObject).toolBar.setTopRankingSize(n2, true);
                    ((GraphViewerBody)eventObject).toolBar.setConnectionWeight(f, true);
                    ((GraphViewerBody)eventObject).drawGraph();
                }
            }
            return;
        }
        if (eventObject == this.menuBar.saveFileMenuItem) {
            eventObject = this;
            int n = ((GraphViewerBody)eventObject).fileDialog.showSaveDialog((Component)eventObject);
            boolean bl = false;
            if (n != 1 && n == 0) {
                File file = ((GraphViewerBody)eventObject).fileDialog.getSelectedFile();
                String string = file.getAbsolutePath();
                if (((ComplexFileFilter)((GraphViewerBody)eventObject).fileDialog.getFileFilter()).accept("csv")) {
                    if (!FileUtils.getFileExtension(file.getName()).equalsIgnoreCase("csv")) {
                        string = string + ".csv";
                    }
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).connections.filter(((GraphViewerBody)eventObject).toolBar.getConnectionWeight(), ((GraphViewerBody)eventObject).toolBar.getAttributesImportance(), ((GraphViewerBody)eventObject).toolBar.getTopSetSize()).save(string)) {
                        bl = true;
                    }
                } else if (((ComplexFileFilter)((GraphViewerBody)eventObject).fileDialog.getFileFilter()).accept("xml")) {
                    if (!FileUtils.getFileExtension(file.getName()).equalsIgnoreCase("xml")) {
                        string = string + ".xml";
                    }
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).graphVisualization.saveGraph(string)) {
                        bl = true;
                    }
                } else if (FileUtils.getFileExtension(file.getName()).equalsIgnoreCase("csv")) {
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).connections.filter(((GraphViewerBody)eventObject).toolBar.getConnectionWeight(), ((GraphViewerBody)eventObject).toolBar.getAttributesImportance(), ((GraphViewerBody)eventObject).toolBar.getTopSetSize()).save(string)) {
                        bl = true;
                    }
                } else if (FileUtils.getFileExtension(file.getName()).equalsIgnoreCase("xml")) {
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).graphVisualization.saveGraph(string)) {
                        bl = true;
                    }
                }
                if (bl) {
                    System.out.println("File is saved.");
                }
            }
            return;
        }
        if (eventObject == this.menuBar.closeFileMenuItem) {
            this.closeFile();
            return;
        }
        if (eventObject == this.menuBar.exitMenuItem) {
            eventObject = this;
            ((Window)eventObject).dispose();
            return;
        }
        if (var1_1 == this.menuBar.aboutMenuItem) {
            if (this.aboutWindow == null) {
                this.aboutWindow = new AboutWindow(new GraphViewerInfo().toString());
            }
            this.aboutWindow.setVisible(true);
        }
    }

    public final void drawGraph() {
        if (this.connections.getNodesNumber() == 0) {
            this.graphPane = this.graphVisualization.getGraph() != null ? new JScrollPane((Component)this.graphVisualization.getGraph()) : new JScrollPane();
        } else {
            this.graph = this.connections.toGraph(this.toolBar.getConnectionWeight(), this.toolBar.getAttributesImportance(), this.toolBar.getTopSetSize());
            this.graphVisualization.createGraph(this.graph);
            this.graphPane = new JScrollPane((Component)this.graphVisualization.getGraph());
        }
        this.horizontalSplitPanel.add((Component)this.graphPane, "bottom");
        this.graphPane.setPreferredSize(new Dimension(790, 500));
    }

    private void closeFile() {
        if (this.connections.getNodesNumber() > 0 || this.graphVisualization.getGraph() != null) {
            System.out.println("Closing file");
            this.connections.init();
            System.out.println("File is closed.");
            this.setTitle("dmLab - ID Graphs Viewer");
            this.graphVisualization.clean();
            this.toolBar.cleanGUI();
            this.drawGraph();
        }
    }

    public final void run() {
        System.out.print(new GraphViewerInfo().toString());
        this.setVisible(true);
    }
}

