% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridges.R
\name{example_gaussian_stan_model}
\alias{example_gaussian_stan_model}
\title{Construct an example BridgeStan \code{StanModel} object for a Gaussian model.}
\usage{
example_gaussian_stan_model(n_data = 50, seed = 1234L)
}
\arguments{
\item{n_data}{Number of independent data points \code{y} to generate and condition
model against from \code{normal(0, 1)}.}

\item{seed}{Integer seed for Stan model.}
}
\value{
BridgeStan StanModel object.
}
\description{
Requires BridgeStan package to be installed. Generative model is assumed to
be of the form \code{y ~ normal(mu, sigma)} for unknown \code{mu ~ normal(0, 3)} and
\code{sigma ~ half_normal(0, 3)}.
}
\examples{
\dontshow{if (requireNamespace("bridgestan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- example_gaussian_stan_model(n_data = 5)
model$param_names()
\dontshow{\}) # examplesIf}
}
