% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rmc.R
\name{plot.rmc}
\alias{plot.rmc}
\title{Plot the repeated measures correlation coefficient.}
\usage{
\method{plot}{rmc}(x, palette = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{an object of class "rmc" generated from the \code{\link{rmcorr}} function.}

\item{palette}{the palette to be used. Defaults to the RColorBrewer "Paired" palette}

\item{xlab}{label for the x axis, defaults to the variable name for measure1.}

\item{ylab}{label for the y axis, defaults to the variable name for measure2.}

\item{...}{additional arguments to \code{\link[graphics:plot.default]{plot}}.}
}
\description{
\code{plot.rmc}  produces a scatterplot of \code{measure1} on the x-axis and
\code{measure2} on the y-axis, with a different color used for each subject.
Parallel lines are fitted to each subject's data.
}
\examples{
## Bland Altman 1995 data
my.rmc <- rmcorr(participant = Subject, measure1 = PaCO2, measure2 = pH, 
                 dataset = bland1995)
plot(my.rmc)

## Raz et al. 2005 data
my.rmc <- rmcorr(participant = Participant, measure1 = Age, measure2 = 
                 Volume, dataset = raz2005)
library(RColorBrewer)
blueset <- brewer.pal(8, 'Blues')
pal <- colorRampPalette(blueset)
plot(my.rmc, overall = TRUE, palette = pal, overall.col = 'black')


## Gilden et al. 2010 data
my.rmc <- rmcorr(participant = sub, measure1 = rt, measure2 = acc, 
                 dataset = gilden2010)
plot(my.rmc, overall = FALSE, lty = 2, xlab = "Reaction Time", 
     ylab = "Accuracy")
     
     
}
\seealso{
\code{\link{rmcorr}, \link{geom_rmc} for plotting with ggplot}
}
