% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{partial}
\alias{partial}
\title{Knit a child document and output as is (render markup)}
\usage{
partial(
  input = NULL,
  ...,
  text = NULL,
  output = NULL,
  quiet = TRUE,
  options = NULL,
  envir = parent.frame(),
  name = NULL,
  show_code = FALSE,
  use_strings = TRUE,
  render_preview = needs_preview(),
  preview_output_format = NULL
)
}
\arguments{
\item{input}{if you specify a file path here, it will be read in before being passed to knitr (to avoid a working directory mess)}

\item{...}{ignored, but you can use it to clarify which variables will be used in the rmd partial}

\item{text}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{output}{if you specify a file path here, where to put the file}

\item{quiet}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{options}{defaults to NULL.}

\item{envir}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{name}{a name to use for cacheing and figure paths. Randomly generated if left unspecified.}

\item{show_code}{whether to print the R code for the partial or just the results (sets the chunk option echo = FALSE while the chunk is being rendered)}

\item{use_strings}{whether to read in the child file as a character string (solves working directory problems but harder to debug)}

\item{render_preview}{true if interactive mode is auto-detected, false when actually knitting the partial as a child}

\item{preview_output_format}{defaults to \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}} with self_contained set to true}
}
\value{
Returns rendered markdown with the class "knit_asis". When used interactively, the knit_meta attributes will additionally contain the path of a rendered preview in a temporary directory.
}
\description{
This modifies and extends the \code{\link[knitr:knit_child]{knitr::knit_child()}} function. Defaults change as follows:
\itemize{
\item the environment defaults to the calling environment, or if passed, to arguments passed via ...
\item the output receives the class \code{knit_asis}, so that the output will be rendered "as is" by knitr when calling inside a chunk (no need to set \code{results='asis'} as a chunk option).
\item defaults to \code{quiet = TRUE}
\item the package additionally renders \code{knit_asis} objects in the viewer when printed to make previewing partials easier. This is achieved using \code{\link[rmarkdown:render]{rmarkdown::render()}} and done in a temporary directory (only when used interactively/not in child mode).
\item the package takes care of some troubles behind the scenes that you might find yourself in if you nest partials (by trying to resolve path ambiguities, using text instead of files for sources, and some functionality to prevent iteratively overwriting generated figures and other files)
}
}
\details{
Why default to the calling environment? Typically this function defaults to the global environment. This makes sense if you want to use knit children in the same context as the rest of the document.
However, you may also want to use knit children to respect conventional scoping rules inside functions to e.g. summarise a regression using a set of commands (e.g. plot some diagnostic graphs and a summary for a regression nicely formatted).

Some caveats:
\itemize{
\item the function has to return to the top-level. There's no way to \code{\link[=cat]{cat()}} this from loops or an if-condition without without setting \code{results='asis'}. You can however concatenate these objects with \code{\link[=paste.knit_asis]{paste.knit_asis()}}
\item currently not yet producing expected results in RStudio notebooks in interactive use
}
}
\examples{
# super simple partial example
partial(text = "Test")

# an example of a wrapper function that calls partial with an argument
# ensures distinct paths for cache and figures, so that these calls can be looped in parallel
regression_diagnostics <- function(regression, ...) {
   partial(system.file("_regression_diagnostics.Rmd",
           package = "rmdpartials", mustWork = TRUE),
           regression = regression, ...)
}
}
