% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_nomogram-function.R
\name{create_nomogram}
\alias{create_nomogram}
\title{Construct nomogram for a machine learning model}
\usage{
create_nomogram(
  sample_features,
  sample_output,
  feature_exp = NULL,
  threshold = 0.5,
  prob = FALSE,
  est = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{sample_features}{A data frame of feature values where each column
represents a feature. The data frame must contain all possible combinations
of feature values. There must be at least one categorical predictor and no
more than one numerical predictor. Only factor and numeric data types are
allowed. The column name 'output' is not allowed. Must not contain any NA
values.}

\item{sample_output}{A data frame with one column 'output' containing
numeric values for either the predicted probabilities (for binary outcomes)
or estimated values (for continuous outcomes). Must not contain any NA
values.}

\item{feature_exp}{Optional data frame containing feature explainability
values (e.g., SHAP values) with one column for each feature. The structure
must match \code{sample_features} in terms of column names. Each column must
contain numeric values. Must not contain any NA values.}

\item{threshold}{A numeric scalar between 0 and 1, used to define the
threshold for classifying predicted probabilities into binary outcomes. A
sample is predicted positive if the predicted probability is equal or
greater than this threshold.}

\item{prob}{A logical scalar indicating if the predicted probabilities
should be shown in the nomogram.}

\item{est}{A logical scalar indicating if the estimated values should be
shown in the nomogram.}

\item{verbose}{A logical scalar indicating whether to show a progress bar if
it is required.}
}
\value{
A ggplot object representing the nomogram.
}
\description{
This function constructs a nomogram for either binary or continuous outcomes
based on provided sample features and outputs. It can also incorporate
feature explainability values, such as SHAP values.
}
\examples{

# Binary outcome (or class-wise multinomial outcome)

## 1 - Categorical predictors and binary outcome without probability
data(nomogram_features)
data(nomogram_outputs)
create_nomogram(nomogram_features, nomogram_outputs)

## 2 - Categorical predictors and binary outcome with probability
create_nomogram(nomogram_features, nomogram_outputs, prob = TRUE)

data(nomogram_shaps)
create_nomogram(
  nomogram_features, nomogram_outputs, nomogram_shaps
  , prob = TRUE
)

## 3 - Categorical and 1 numerical predictors and binary outcome with probability
data(nomogram_features2)
data(nomogram_outputs2)
create_nomogram(nomogram_features2, nomogram_outputs2, prob = TRUE)

data(nomogram_shaps2)
create_nomogram(
  nomogram_features2, nomogram_outputs2, nomogram_shaps2
  , prob = TRUE
)

# Continuous outcome

## 4 - Categorical predictors and continuous outcome
data(nomogram_features3)
data(nomogram_outputs3)
create_nomogram(nomogram_features3, nomogram_outputs3, est = TRUE)

data(nomogram_shaps3)
create_nomogram(
  nomogram_features3, nomogram_outputs3, nomogram_shaps3
  , est = TRUE
)

## 5 - Categorical and 1 numerical predictors and continuous outcome
data(nomogram_features4)
data(nomogram_outputs4)
create_nomogram(nomogram_features4, nomogram_outputs4, est = TRUE)

data(nomogram_shaps4)
create_nomogram(
  nomogram_features4, nomogram_outputs4, nomogram_shaps4
  , est = TRUE
)
}
\keyword{ml-nomogram}
