% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{bouquet}
\alias{bouquet}
\title{Bouquet plot}
\usage{
bouquet(
  x,
  Kmax = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Restricted mean win/loss time",
  ylab = "Follow-up time",
  group.label = TRUE,
  cex.group = 1,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{rmtfit}}.}

\item{Kmax}{A positive integer; If specified, the stage-wise estimates over
\code{Kmax}\eqn{,\ldots,K} will be aggregated.}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{A label for the x axis, defaults to a description of x.}

\item{ylab}{A label for the y axis, defaults to a description of x.}

\item{group.label}{If \code{TRUE}, group labels will appear on the
two sides of the plot.}

\item{cex.group}{Font size of the group labels if \code{group.label=TRUE}.}

\item{...}{Other arguments that can be passed to the underlying \code{plot} method.}
}
\value{No return value, called for side effects.}
\description{
Construct the bouquet plot based on the estimated stage-wise restricted mean win/loss
times.
}
\examples{
# load the colon cancer trial data
library(rmt)
head(colon_lev)
# fit the data
obj=rmtfit(ms(id,time,status)~rx,data=colon_lev)
# bouquet plot
bouquet(obj)
}
\seealso{
\code{\link{rmtfit}}, \code{\link{summary.rmtfit}},
 \code{\link{plot.rmtfit}}.
}
\keyword{rmtfit}
