% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myTarAuth.R
\name{myTarAuth}
\alias{myTarAuth}
\title{Authentication in 'MyTarget API'}
\usage{
myTarAuth(
  login = getOption("rmytarget.login"),
  grant_type = "client_credentials",
  client_id = getOption("rmytarget.client_id"),
  client_secret = getOption("rmytarget.client_secret"),
  agency_client_name = NULL,
  code_grant = getOption("rmytarget.code_grant_auth"),
  token_path = myTarTokenPath()
)
}
\arguments{
\item{login}{Account name, used in file name if you save credential}

\item{grant_type}{Your account grant, get one of two values, "client_credentials" or "agency_client_credentials". Not use in Code Grant Schema.}

\item{client_id}{Yoyr client ID. Not use in Code Grant Schema.}

\item{client_secret}{Your client secret. Not use in Code Grant Schema.}

\item{agency_client_name}{Your client user name. Only for "agency_client_credentials" grant_type.}

\item{code_grant}{logical, Use code gran authorise schema, \href{https://target.my.com/help/advertisers/api_authorization/ru}{detail}}

\item{token_path}{Path to directory where you save credential data.}
}
\value{
No return value, called for side effects
}
\description{
Authentication in 'MyTarget API' by Code Grant Schema or other auth schems. For detail you can see \href{https://target.my.com/help/advertisers/api_authorization/ru}{documentation}.
}
\examples{
\dontrun{
# Recomendation auth by code grant schema
myTarAuth(login = "my_account_name")

}						  
}
\seealso{
API authorization \href{https://target.my.com/help/advertisers/api_authorization/ru}{documentation} by 'MyTarget'.
}
\author{
Alexey Seleznev
}
