% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_goldprice.R
\name{get_goldprice_from_interval}
\alias{get_goldprice_from_interval}
\title{Retrieves the gold prices from a specific interval.}
\usage{
get_goldprice_from_interval(from, to)
}
\arguments{
\item{from}{start day of the interval.}

\item{to}{end day of the interval.}
}
\value{
nbp_api_response object containing the gold prices
from the specified interval.
}
\description{
Retrieves the gold prices from a specific interval.
}
\details{
As gold prices are not published on the weekends
fetching values from an interval containing a weekend will
result in a response that omits those days.
}
\examples{
\donttest{
tryCatch(
  {
    ## Fetch the gold prices from the past week
    response <- get_goldprice_from_interval(Sys.Date() - 7, Sys.Date())
    ## Preview response content
    response$content
  },
  error = function(e) message(e)
)
}

}
\seealso{
\url{https://api.nbp.pl/#cenyZlota}

Other goldprice: 
\code{\link{get_current_goldprice}()},
\code{\link{get_goldprice_from}()},
\code{\link{get_last_n_goldprices}()},
\code{\link{get_todays_goldprice}()}
}
\concept{goldprice}
