% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depthgram.R
\name{depthgram}
\alias{depthgram}
\alias{depthgram.default}
\alias{depthgram.fData}
\alias{depthgram.mfData}
\title{Depthgram for univariate and multivariate functional data sets}
\usage{
depthgram(
  Data,
  marginal_outliers = FALSE,
  boxplot_factor = 1.5,
  outliergram_factor = 1.5,
  ids = NULL
)

\method{depthgram}{default}(
  Data,
  marginal_outliers = FALSE,
  boxplot_factor = 1.5,
  outliergram_factor = 1.5,
  ids = NULL
)

\method{depthgram}{fData}(
  Data,
  marginal_outliers = FALSE,
  boxplot_factor = 1.5,
  outliergram_factor = 1.5,
  ids = NULL
)

\method{depthgram}{mfData}(
  Data,
  marginal_outliers = FALSE,
  boxplot_factor = 1.5,
  outliergram_factor = 1.5,
  ids = NULL
)
}
\arguments{
\item{Data}{A \code{\link[base]{list}} of length \code{L} (number of components)
in which each element is an \verb{N x P} matrix with \code{N} individuals and \code{P}
time points. Alternatively, it can also be an object of class
\code{\link{fData}} or of class \code{\link{mfData}}.}

\item{marginal_outliers}{A boolean specifying whether the function should
return shape and amplitude outliers over each dimension. Defaults to
\code{FALSE}.}

\item{boxplot_factor}{A numeric value specifying the inflation factor for
marginal functional boxplots. This is ignored if \code{marginal_outliers == FALSE}. Defaults to \code{1.5}.}

\item{outliergram_factor}{A numeric value specifying the inflation factor for
marginal outliergrams. This is ignored if \code{marginal_outliers == FALSE}.
Defaults to \code{1.5}.}

\item{ids}{A character vector specifying labels for individual observations.
Defaults to \code{NULL}, in which case observations will remain unlabelled.}
}
\value{
An object of class \code{depthgram} which is a list with the following
items:
\itemize{
\item \code{mbd.mei.d}: vector MBD of the MEI dimension-wise.
\item \code{mei.mbd.d}: vector MEI of the MBD dimension-wise.
\item \code{mbd.mei.t}: vector MBD of the MEI time-wise.
\item \code{mei.mbd.t}: vector MEI of the MEI time-wise.
\item \code{mbd.mei.t2}: vector MBD of the MEI time/correlation-wise.
\item \code{mei.mbd.t2}: vector MEI of the MBD time/correlation-wise.
\item \code{shp.out.det}: detected shape outliers by dimension.
\item \code{mag.out.det}: detected magnitude outliers by dimension.
\item \code{mbd.d}: matrix \verb{n x p} of MBD dimension-wise.
\item \code{mei.d}: matrix \verb{n x p} of MEI dimension-wise.
\item \code{mbd.t}: matrix \verb{n x p} of MBD time-wise.
\item \code{mei.t}: matrix \verb{n x p} of MEI time-wise.
\item \code{mbd.t2}: matrix \verb{n x p} of MBD time/correlation-wise
\item \code{mei.t2}: matrix \verb{n x p} of MBD time/correlation-wise.
}
}
\description{
This function computes the three 'DepthGram' representations from a p-variate
functional data set.
}
\examples{
N <- 2e2
P <- 1e3
grid <- seq(0, 1, length.out = P)
Cov <- exp_cov_function(grid, alpha = 0.3, beta = 0.4)

Data <- list()
Data[[1]] <- generate_gauss_fdata(
  N,
  centerline = sin(2 * pi * grid),
  Cov = Cov
)
Data[[2]] <- generate_gauss_fdata(
  N,
  centerline = sin(2 * pi * grid),
  Cov = Cov
)
names <- paste0("id_", 1:nrow(Data[[1]]))

DG1 <- depthgram(Data, marginal_outliers = TRUE, ids = names)

fD <- fData(grid, Data[[1]])
DG2 <- depthgram(fD, marginal_outliers = TRUE, ids = names)

mfD <- mfData(grid, Data)
DG3 <- depthgram(mfD, marginal_outliers = TRUE, ids = names)
}
\references{
Aleman-Gomez, Y., Arribas-Gil, A., Desco, M. Elias-Fernandez, A., and Romo,
J. (2021). "Depthgram: Visualizing Outliers in High Dimensional Functional
Data with application to Task fMRI data exploration".
}
