% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN_plots.R
\name{plot.robin}
\alias{plot.robin}
\title{plot.robin}
\usage{
\method{plot}{robin}(x, title = "Robin plot", ...)
}
\arguments{
\item{x}{A robin class object. The output of the functions:
\code{\link{robinRobust}} and \code{\link{robinCompare}}.}

\item{title}{The title for the graph. The default is "Robin plot".}

\item{...}{other parameter}
}
\value{
A ggplot object.
}
\description{
This function plots two curves: the measure of the null model and the measure
of the real graph or the measure of the two community detection algorithms.
}
\examples{
\dontrun{my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
comp <- robinCompare(graph=graph, method1="fastGreedy",method2="louvain")
plot(comp)}

}
