% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_tssid.R
\name{generate_tssid}
\alias{generate_tssid}
\title{Generate a TSSID}
\usage{
generate_tssid(x = Sys.time(), addDelimiters = FALSE, designationSymbol = "=")
}
\arguments{
\item{x}{The date and time to use.}

\item{addDelimiters}{If \code{TRUE}, add the delimiters (by default, \code{[[} and
\verb{]]}).}

\item{designationSymbol}{The symbol to use to designate an instance
identifier for a class (can be "\code{=}" or "\code{:}" as per the ROCK standard).}
}
\value{
The tssid
}
\description{
A TSSID is a Timestamped Source Identifier. It is a practically
unique identifier for a source, conventionally the time and date
the source was produced (e.g. when the data were collected, for example
the time and date of an interview) in the UTC timezone and in ISO 8601
standard format.
}
\examples{
rock::generate_tssid();
}
