% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{rockr.eval}
\alias{rockr.eval}
\title{Evaluate a R script}
\usage{
rockr.eval(conn, script, json = FALSE, async = FALSE)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{script}{R script to execute.}

\item{json}{Response is in JSON format or an object serialized by R. Default is FALSE.}

\item{async}{R script is executed asynchronously within the session (default is FALSE).
If TRUE, the value returned is the command object to look for.}
}
\value{
The unserialized result object.
}
\description{
Execute a R script in the remote R session.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
rockr.eval(conn, "x <- 'foo'")
rockr.eval(conn, "ls()")
rockr.close(conn)
}
}
\seealso{
Other evaluation functions: 
\code{\link{rockr.eval.source}()}
}
\concept{evaluation functions}
