% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{transform_to_measure}
\alias{transform_to_measure}
\alias{transform_to_measure.flat_table}
\title{Transform to measure}
\usage{
transform_to_measure(ft, attributes, k_sep, decimal_sep)

\method{transform_to_measure}{flat_table}(ft, attributes, k_sep = NULL, decimal_sep = NULL)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{attributes}{A vector of strings, attribute names.}

\item{k_sep}{A character, thousands separator to remove.}

\item{decimal_sep}{A character, new decimal separator to use, if necessary.}
}
\value{
ft A \code{flat_table} object.
}
\description{
Transform attributes into measures.
}
\details{
We can indicate a thousands indicator to remove and a decimal separator to use.
The only decimal separators considered are "." and ",".
}
\examples{

ft <- flat_table('iris', iris) |>
  transform_to_attribute(measures = "Sepal.Length", decimal_places = 2) |>
  transform_to_measure(attributes = "Sepal.Length", decimal_sep = ".")

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
