% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_formats.R
\name{file_formats}
\alias{file_formats}
\title{Supported file formats}
\description{
Please note that most of this documentation has been adapted from Osmium
documentation. Please see
\url{https://docs.osmcode.org/osmium/latest/osmium-file-formats.html} for the
original documentation.
\subsection{File types}{

OSM uses three types of files for its main data:
\itemize{
\item Data files: these are the most common files. They contain the OSM data from
a specific point in time. At most one version of every object (node, way or
relation) is contained in this file. Deleted objects are not in this file.
The usual suffix used is \code{.osm}.
\item History files: these files contain not only the current version of an
object, but their history too. So for any object (node, way or relation)
there can be zero or more versions in this file. Deleted objects can also be
in this file. The usual suffix used is \code{.osm} or \code{.osh}. Because sometimes
the same suffix is used as for normal data files (\code{.osm}) and because there
is no clear indicator in the header, it is not always clear what type of file
you have in front of you.
\item Change files: sometimes called \emph{diff files} or \emph{replication diffs}, these
files contain the changes between one state of the OSM database and another
state. Change files can contains several versions of an object and also
deleted objects. The usual suffix used is \code{.osc}.
}

All these files have in common that they contain OSM objects (nodes, ways
and relations). History files and change files can contain several versions
of the same object and also deleted objects; data files can't.

Where possible, Osmium commands can handle all file types. For some commands
only some file types make sense.
}

\subsection{Formats}{

Osmium supports all major OSM file formats plus some more. These are:
\itemize{
\item The classical XML format in the variants \code{.osm} (for data files), \code{.osh}
(for data files with history) and \code{.osc} (for change files).
\item The PBF binary format (usually with suffix \code{.osm.pbf} or just \code{.pbf}).
\item The OPL format (usually with suffix \code{.osm.opl} or just \code{.opl}).
\item The O5M/O5C format (usually with suffix \code{.o5m} or \code{.o5c}) (reading only).
\item The "debug" format (usually with suffix \code{.osm.debug}) (writing only).
}

In addition, files in all formats except PBF can be compressed using \emph{gzip}
or \emph{bzip2} (add \code{.gz} or \code{.bz2} suffixes, respectively - e.g.
\code{data.osm.bz2}).
}
}
