% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/punch.R
\name{punch}
\alias{punch}
\title{Roundhouse punch}
\usage{
punch(
  text = NULL,
  width = 35,
  size = 20,
  color = "white",
  fps = NULL,
  loop = 0,
  sound = FALSE,
  sound_repeat = 1,
  sound_delay = 0,
  ...
)
}
\arguments{
\item{text}{Character string specifying the text to display with the
roundhouse (preferably, a Chuck Norris fact). If \code{NULL}, a fact is
selected at random from the ICNDb.}

\item{width}{Integer specifying the number of characters per line. Default is
35}

\item{size}{Integer specifying the font size in pixels. Default is 10.}

\item{color}{Character string specifying the color of the text.}

\item{fps}{Integer specifying the frames per second of the roundhouse punch.
(Must be a factor of 100.)}

\item{loop}{Integer specifying the number of times the roundhouse punch
should be repeated. Though a single roundhouse punch is always sufficient,
the default is \code{0} which results in an infinite number of roundhouse
punches.}

\item{sound}{Logical indicating whether or not "Chuck Norris" should be
shouted when generating random facts. Default is \code{FALSE}.}

\item{sound_repeat}{Integer specifying the number of times the sound should
be repeated. Default is 1. (Only matters if \code{sound = TRUE}.)}

\item{sound_delay}{Integer specifying the delay (in seconds) to wait before
shouting "Chuck Norris". Default is 0. (Only matters if \code{sound = TRUE}.)}

\item{...}{Additional optional arguments to be passed onto
\code{\link[magick]{image_annotate}}.}
}
\description{
Generate a roundhouse punch from Chuck Norris...with a random fact (or user-
supplied text).
}
\examples{
\dontrun{
# Random fact
punch(width = 40, size = 15)

# User-supplied text
punch("Chuck Norris can’t test for equality because he has no equal.",
     type = 2, width = 40, size = 25, fps = 5)
}
}
