% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutines.R
\name{ftemp_arrh}
\alias{ftemp_arrh}
\title{Calculates the Arrhenius-type temperature response}
\usage{
ftemp_arrh(tk, dha, tkref = 298.15)
}
\arguments{
\item{tk}{Temperature (Kelvin)}

\item{dha}{Activation energy (J mol-1)}

\item{tkref}{Reference temperature (Kelvin)}
}
\value{
A numeric value for \eqn{f}
}
\description{
Given a kinetic rate at a reference temperature (argument \code{tkref})
this function calculates its temperature-scaling factor
following Arrhenius kinetics.
}
\details{
To correct for effects by temperature following Arrhenius kinetics,
and given a reference temperature \eqn{T_0}, \eqn{f} calculates the temperature
scaling. Arrhenius kinetics are described by an equation of form
\eqn{x(T)= exp(c - \Delta H_a / (T R))}. The temperature-correction
function \eqn{f(T, \Delta H_a)} is thus given by \eqn{f=x(T)/x(T_0)} which is:
\deqn{
     f = exp( \Delta H_a (T - T_0) / (T_0 R T_K) )
}
\eqn{\Delta H_a} is given by argument \code{dha}. \eqn{T} is given by argument
\code{tk} and has to be provided in Kelvin. \eqn{R} is the universal gas constant
and is 8.3145 J mol-1 K-1. Note that this is equivalent to 
\deqn{
     f = exp( (\Delta H_a/R) (1/T_0 - 1/T) )  
}
}
\examples{
# Relative rate change from 25 to 10 degrees Celsius (percent change)
print( (1.0-ftemp_arrh( 283.15, 100000, tkref = 298.15))*100 )

}
