% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLogBoxsize.R
\name{getLogBoxsize}
\alias{getLogBoxsize}
\title{Determine an appropriate boxsize, if you want to use logarithmic scale.}
\usage{
getLogBoxsize(percent)
}
\arguments{
\item{percent}{a numeric value defining the percent}
}
\value{
a numeric value which is equivalent to the percental change given on a logarithmic scale
}
\description{
This function returns an appropriate boxsize if you want to do your point and figure analysis with an logarithmic scale.
}
\examples{
# apply it with pnfprocessor
library(rpnf) # Load rpnf library
data(DOW) # Load some example data

# return appropriate value for 1\% boxsize
getLogBoxsize(percent=1)

pnfprocessor(
 high=DOW$High,
 low=DOW$Low,
 date=DOW$Date,
 boxsize=getLogBoxsize(percent=1),
 log=TRUE)
}

