% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rqcan}
\alias{rqcan}
\title{Canonical Quantile Regression.}
\usage{
rqcan(
  X,
  Y,
  tau = 0.5,
  a.pos = 1,
  ap = rep(1, na),
  na = ncol(Y),
  wts = rep(1, nrow(X))
)
}
\arguments{
\item{X}{input design matrix of explanatory variables (without intercept)}

\item{Y}{input matrix of response variables (nrow(Y) = nrow(X))}

\item{tau}{desired quantile, default = .5}

\item{a.pos}{for first component: non-empty vector of indices of Y-variables (Y-columns) whose alpha coefficients are constrained to be positive (to provide the direction of increasing responses); default = 1}

\item{ap}{for subsequent components j = 2, 3, . . . , na: vector whose (j-1)-th element is the Y-variable (column) index whose alpha coefficients are constrained to be positive; default = rep(1,na-1)}

\item{na}{number of components desired (1 <= na <= ncol(Y))}

\item{wts}{used only for use with the bootstrap methods. If weighting is desired for the sample observations, rqcan will multiply the columns of X and Y by the vector wts; but the bootstrap methods will apply to the unweighted data, and so will be incorrect; default = rep(1,nrow(X)) (unweighted analysis)}
}
\value{
object of class "rqcan"; a list of matrices of the alpha and beta coefficients: the j-th row of each matrix is the coefficients for the j-th component; input data and the constraint matrices R an r are also returned in the list
}
\description{
Given multivariate data matrices X (explanatory variables) and Y (response variables), the function fits coefficients of the Y-variables that are best fit by a quantile regression on X. These are analogous to the coefficients given by a classical canonical correlations analysis, but replace the implicit L2 norm by an L1 norm. See: "Method" and "Reference" below.

This is a simple S3 class for display formatting purposes.
}
\details{
Finds orthogonal alpha coefficients and corresponding best-fitting beta coefficients to minimize sum|x_i' beta - y_i' alpha| subject to sum|alpha| = 1 (where x_i and y_i are the i-th rows of X and Y). The intercept is included (X should not include intercept). Need ncol(Y) > 1. For first component: if length(a.pos) < ncol(Y), sum(|alpha|) = 1  is constrained by going through all sign choices (s_j = sign(alpha_j)) and setting Y1_j =  s_j Y_j  (j not in a.pos). A constrained regression quantile fit is applied from quantreg: rq.fit.fnc(cbind(1,X,Y1),y0=0,R,r,tau). where (R,r) constrains all alpha_j >= 0 and sum(alpha_j) >= 1 (sum = 1 at min). Note: rq.fit.fnc solves by generating a sequence of quadratic approximations. The matrix defining one quadratic problem may be singular (and stop the computation) even if he input design matrices are of full rank. If a singularity stop occurs, jittering the data (see jitter()) sometimes helps.For the subsequent j-th component, only the index given by ap(j-1) is constrained to be positive. Alpha coefficients for subsequent components are constrained to be orthogonal to previous alpha coefficients.
}
\section{Fields}{

\describe{
\item{\code{list}}{A list.}
}}

\examples{
X <- as.matrix(example_data[,1:3])
Y <- as.matrix(example_data[,4:7])

a <- rqcan(X,Y,tau=.75,a.pos=2)
summary(a)
}
\references{
S. Portnoy, 2022. Canonical quantile regression, J. Multivar. Anal., 192, 105071.
}
\seealso{
See \link{summary.rqcan} for a description of the summary function.
}
