% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrmix.sim.norm.R
\name{rrmix.sim.norm}
\alias{rrmix.sim.norm}
\title{Simulation Data Generator}
\usage{
rrmix.sim.norm(
  K = 2,
  n = 100,
  p = 5,
  q = 5,
  rho = 0.5,
  b = 1,
  shift = 1,
  r.star = NULL,
  sigma = NULL,
  pr = NULL,
  seed = NULL
)
}
\arguments{
\item{K}{number of mixture components.}

\item{n}{number of observations.}

\item{p}{number of predictors including an intercept.}

\item{q}{number of responses.}

\item{rho}{correlation between predictors used to make a design matrix.}

\item{b}{signal strength which controls the magnitude of coefficient matrices.}

\item{shift}{mean shift which measures how separate the mixture components are.}

\item{r.star}{vector of length K, specifying the true ranks of K coefficient
matrices.}

\item{sigma}{vector of length K, specifying the noise strength of K
multivariate normal distributions.}

\item{pr}{vector of length K, specifying the multinomial probabilities for
the K mixture components.}

\item{seed}{seed number for the reproducibility of results. Default is `NULL'.}
}
\value{
\item{X}{n by p design matrix.}
  \item{Y}{n by q response matrix.}
  \item{E}{p by q error matrix.}
  \item{ind.true}{vector of length n, specifying the true mixture membership
  for n observations.}
  \item{para.true}{array of length K. It consists of K lists, each of which
  contains a coefficient matrix and its true rank.}
}
\description{
`rrmix.sim.norm' is used to create synthetic data from the multivariate
normal distribution, which is used in a numerical study of Kang et. al.
(2022+).
}
\examples{
#-----------------------------------------------------------#
# Simulation 1: Two Components Case
#-----------------------------------------------------------#
K2mod <- rrmix.sim.norm(K = 2, n = 100, p = 5, q = 5, rho = .5,
         b = 1, shift = 1, r.star = c(1, 3), sigma = c(1, 1),
         pr = c(.5, .5), seed = 1215)

#-----------------------------------------------------------#
# Simulation 2: Four Components Case
#-----------------------------------------------------------#
K4mod <- rrmix.sim.norm(K = 4, n = 600, p = 15, q = 15,
         rho = .5, b = 1, shift = 1, r.star = c(1, 1, 3, 3),
         sigma = c(1, 1, 1, 1), pr = c(.25, .25, .25, .25),
         seed = 1215)
}
\references{
Kang, S., Chen, K., and Yao, W. (2022+). "Reduced rank estimation in mixtures
  of multivariate linear regression".
}
\author{
Suyeon Kang, University of California, Riverside, \email{skang062@ucr.edu};
  Weixin Yao, University of California, Riverside, \email{weixin.yao@ucr.edu};
  Kun Chen, University of Connecticut, \email{kun.chen@uconn.edu}.
}
