% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{residuals}
\alias{residuals}
\title{Reduced-Rank Regression Residuals}
\usage{
residuals(x, y, type = "identity", rank = "full", k = 0, plot = TRUE)
}
\arguments{
\item{x}{data frame or matrix of predictor variables}

\item{y}{data frame or matrix of response variables}

\item{type}{type of reduced-rank regression model to fit. \code{type = "identity"}, the default, uses \eqn{\mathbf{\Gamma} = \mathbf{I}} to fit a reduced-rank regression. \code{type = "pca"} fits a principal component analysis model as a special case of reduced-rank regression. \code{type = "cva"} fits a canonical variate analysis model as a special case of reduced-rank regression. \code{type = "lda"} fits a linear discriminant analysis model as a special case of reduced-rank regression.}

\item{rank}{rank of coefficient matrix.}

\item{k}{small constant added to diagonal of covariance matrices to make inversion easier.}

\item{plot}{if FALSE, returns data frame of rank trace coordinates.}
}
\value{
scatterplot matrix of residuals if \code{plot = TRUE}, the default, or a data frame of residuals if \code{plot = FALSE}.
}
\description{
\code{residuals} calculates the regression residuals for reduced-rank regression and canonical variate analysis.
}
\examples{
data(tobacco)
tobacco_x <- tobacco[,4:9]
tobacco_y <- tobacco[,1:3]
tobacco_rrr <- rrr(tobacco_x, tobacco_y, rank = 1)
residuals(tobacco_x, tobacco_y, rank = 1, plot = FALSE)
residuals(tobacco_x, tobacco_y, rank = 1)

library(dplyr)
data(COMBO17)
galaxy <- as_data_frame(COMBO17)
galaxy <- select(galaxy, -starts_with("e."), -Nr, -UFS:-IFD)
galaxy <- na.omit(galaxy)
galaxy_x <- select(galaxy, -Rmag:-chi2red)
galaxy_y <- select(galaxy, Rmag:chi2red)
residuals(galaxy_x, galaxy_y, type = "cva", rank = 2, k = 0.001)

}
\references{
Izenman, A.J. (2008) \emph{Modern Multivariate Statistical Techniques}. Springer.
}

