% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploySite.R
\name{deploySite}
\alias{deploySite}
\title{Deploy a website}
\usage{
deploySite(
  siteDir = getwd(),
  siteName = NULL,
  siteTitle = NULL,
  account = NULL,
  server = NULL,
  render = c("none", "local", "server"),
  launch.browser = getOption("rsconnect.launch.browser", interactive()),
  logLevel = c("normal", "quiet", "verbose"),
  lint = FALSE,
  metadata = list(),
  python = NULL,
  recordDir = NULL,
  ...
)
}
\arguments{
\item{siteDir}{Directory containing website. Defaults to current directory.}

\item{siteName}{Name for the site (names must be unique within
an account). Defaults to the base name of the specified \code{siteDir}
or to the name provided by a custom site generation function.}

\item{siteTitle}{Title for the site. For quarto sites only, if not
supplied uses the title recorded in \verb{_quarto.yml}.}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{render}{Rendering behavior for site:
\itemize{
\item \code{"none"} uploads a static version of the current contents of
the site directory.
\item \code{"local"} renders the site locally then uploads it.
\item \code{"server"} uploads the source of the site to render on the server.
}

Note that for \code{"none"} and \code{"local"} source files (e.g. \code{.R}, \code{.Rmd} and
\code{.md}) will not be uploaded to the server.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to \code{TRUE} in
interactive sessions only. If a function is passed, it will be called
after the app is started, with the app URL as a paramter.}

\item{logLevel}{One of \code{"quiet"}, \code{"normal"} or \code{"verbose"}; indicates how
much logging to the console is to be performed. At \code{"quiet"} reports no
information; at \code{"verbose"}, a full diagnostic log is captured.}

\item{lint}{Lint the project before initiating deployment, to identify
potentially problematic code?}

\item{metadata}{Additional metadata fields to save with the deployment
record. These fields will be returned on subsequent calls to
\code{\link[=deployments]{deployments()}}.

Multi-value fields are recorded as comma-separated values and returned in
that form. Custom value serialization is the responsibility of the caller.}

\item{python}{Full path to a python binary for use by \code{reticulate}.
Required if \code{reticulate} is a dependency of the app being deployed.
If python = NULL, and RETICULATE_PYTHON or RETICULATE_PYTHON_FALLBACK is
set in the environment, its value will be used. The specified python binary
will be invoked to determine its version and to list the python packages
installed in the environment.}

\item{recordDir}{The default, \code{NULL}, uses \code{siteDir}.}

\item{...}{Additional arguments to \code{\link[=deployApp]{deployApp()}}. Do not supply \code{appDir}
or \code{appFiles}; these parameters are automatically generated by
\code{deploySite()}.}
}
\description{
Deploy an R Markdown or quarto website to a server.

Supported servers: Posit Connect, Posit Connect Cloud and ShinyApps servers
}
\seealso{
Other Deployment functions: 
\code{\link{applications}()},
\code{\link{deployAPI}()},
\code{\link{deployApp}()},
\code{\link{deployDoc}()},
\code{\link{deployTFModel}()}
}
\concept{Deployment functions}
