% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.simsum.R
\name{print.summary.simsum}
\alias{print.summary.simsum}
\title{print.summary.simsum}
\usage{
\method{print}{summary.simsum}(x, digits = 4, mcse = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{summary.simsum}.}

\item{digits}{Number of significant digits used for printing.
Defaults to 4.}

\item{mcse}{Should Monte Carlo standard errors be reported?
If \code{mcse = FALSE}, confidence intervals based on Monte Carlo standard errors will be reported instead, see \code{\link[=summary.simsum]{summary.simsum()}}.
If a \code{NULL} value is passed, only point estimates are printed regardless of whether Monte Carlo standard errors were computed or not.
Defaults to \code{TRUE}.}

\item{...}{Ignored.}
}
\description{
Print method for \code{summary.simsum} objects
}
\examples{
data("MIsim")
x <- simsum(
  data = MIsim, estvarname = "b", true = 0.5, se = "se",
  methodvar = "method"
)
xs <- summary(x)
xs

# Printing less significant digits:
print(xs, digits = 2)

# Printing confidence intervals:
print(xs, mcse = FALSE)

# Printing values only:
print(xs, mcse = NULL)
}
