% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxpsmatch.R
\name{coxpsmatch}
\alias{coxpsmatch}
\title{Propensity Score Matching with Time-Dependent Covariates}
\usage{
coxpsmatch(
  n_pairs = 10^10,
  data,
  id = "id",
  time = "time",
  trt_time = "trt_time",
  covariates = NULL,
  exact_match = NULL,
  options = list(time_lag = FALSE)
)
}
\arguments{
\item{n_pairs}{The number of pairs desired from matching.}

\item{data}{A data.frame or similar containing columns matching the \verb{id, time, trt_time} arguments, and covariates. This data frame is expected to
be in tidy, long format, so that \code{id}, \code{trt_time}, and other variables may
be repeated for different values of \code{time}. The data.frame should be unique
at \code{id} and \code{time}.}

\item{id}{A character specifying the id column name (default \code{'id'}).}

\item{time}{A character specifying the time column name (default \code{'time'}).}

\item{trt_time}{A character specifying the treatment time column name
(default \code{'trt_time'}).}

\item{covariates}{A character vector specifying the covariates to use for
matching (default \code{NULL}). If \code{NULL}, this will default to all columns
except those named by the \code{id}, \code{time}, and \code{trt_time} arguments.}

\item{exact_match}{A vector of optional covariates to perform exact matching
on. If \code{NULL}, no exact matching is done.}

\item{options}{A list of additional parameters with the following components:
\itemize{
\item \code{time_lag} A logical value indicating whether the matches should be made
on the time period preceding treatment.  This can help avoid confounding if
treatment happens between two periods.
}}
}
\value{
A data frame containing the pair information.  The data frame has
columns \code{id}, \code{pair_id}, and \code{type}. \code{id} matches the input parameter and
will contain all ids from the input data frame.  \code{pair_id} refers to the id
of the computed pairs; \code{NA} values indicate unmatched individuals.  \code{type}
indicates whether the individual in the pair is considered as treatment
("trt") or control ("all") in that pair.
}
\description{
Perform propensity score matching as described in Lu (2005) "Propensity Score
Matching with Time-Dependent Covariates".  Given a longitudinal data frame
with covariate information, along with treatment time, match treated
individuals to those that haven't been treated yet (or are never treated)
based on time-dependent propensity scores from a Cox proportional hazards
model. Each treated individual is matched to one other individual, unless the
number of pairs is specified.
}
\examples{
if (requireNamespace("survival", quietly = TRUE) &
  requireNamespace("nbpMatching", quietly = TRUE)) {
  library(dplyr, quietly = TRUE)
  pairs <- coxpsmatch(
    n_pairs = 13,
    data = oasis,
    id = "subject_id",
    time = "visit",
    trt_time = "time_of_ad"
  )

  na.omit(pairs)

  # evaluate the first match
  first_match <- pairs$subject_id[which(pairs$pair_id == 1)]
  oasis \%>\% dplyr::filter(subject_id \%in\% first_match)
}

}
\references{
Lu, Bo. 2005. "Propensity Score Matching with Time-Dependent
Covariates." Biometrics 61 (3): 721-28.
\doi{10.1111/j.1541-0420.2005.00356.x}
}
\author{
Mitchell Paukner
}
