% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLN_JRS.R
\name{LLN_JRS}
\alias{LLN_JRS}
\title{Calculate LLN of spirometry parameters using JRS (2014) equations}
\usage{
LLN_JRS(age, height, gender = 1, param = "FEV1")
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{param}{A character vector, containing one of more of the following parameters (case insensitive):
"FEV1", "FVC", "VC", "FEV1FVC"}
}
\value{
If \code{param} has length one, the function returns a numeric vector. If \code{param}
has length >1, it returns a data.frame with \code{length(param)} columns.
}
\description{
This function calculates LLNs (Lower Limits of Normal) for the various spirometry
parameters, using the JRS (Japanese Respiratory Society 2014) equations. 
It accepts as input age, height, gender.
}
\details{
Arguments \code{age}, \code{height} and \code{gender} are vectors
of equal length, or of length one, in which case the value is recycled; if the four vectors are
not of equal length, the function stops with an error.
}
\examples{
# Find LLN of FEV1 and FVC for Japanese women aged 20 to 70 and with a height of 1.70 meters.
LLN_JRS(20:70, 1.7, 2, param=c("FEV1","FVC"))

}
